/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.RetrieverConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRetrieverRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, UpdateRetrieverRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(UpdateRetrieverRequest.getter(UpdateRetrieverRequest::applicationId)).setter(UpdateRetrieverRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> RETRIEVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retrieverId").getter(UpdateRetrieverRequest.getter(UpdateRetrieverRequest::retrieverId)).setter(UpdateRetrieverRequest.setter(Builder::retrieverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("retrieverId").build()}).build();
    private static final SdkField<RetrieverConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(UpdateRetrieverRequest.getter(UpdateRetrieverRequest::configuration)).setter(UpdateRetrieverRequest.setter(Builder::configuration)).constructor(RetrieverConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateRetrieverRequest.getter(UpdateRetrieverRequest::displayName)).setter(UpdateRetrieverRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateRetrieverRequest.getter(UpdateRetrieverRequest::roleArn)).setter(UpdateRetrieverRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, RETRIEVER_ID_FIELD, CONFIGURATION_FIELD, DISPLAY_NAME_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("retrieverId", RETRIEVER_ID_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
        }
    });
    private final String applicationId;
    private final String retrieverId;
    private final RetrieverConfiguration configuration;
    private final String displayName;
    private final String roleArn;

    private UpdateRetrieverRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.retrieverId = builder.retrieverId;
        this.configuration = builder.configuration;
        this.displayName = builder.displayName;
        this.roleArn = builder.roleArn;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String retrieverId() {
        return this.retrieverId;
    }

    public final RetrieverConfiguration configuration() {
        return this.configuration;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRetrieverRequest)) {
            return false;
        }
        UpdateRetrieverRequest other = (UpdateRetrieverRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.retrieverId(), other.retrieverId()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRetrieverRequest").add("ApplicationId", (Object)this.applicationId()).add("RetrieverId", (Object)this.retrieverId()).add("Configuration", (Object)this.configuration()).add("DisplayName", (Object)this.displayName()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "retrieverId": {
                return Optional.ofNullable(clazz.cast(this.retrieverId()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRetrieverRequest, T> g) {
        return obj -> g.apply((UpdateRetrieverRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String retrieverId;
        private RetrieverConfiguration configuration;
        private String displayName;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRetrieverRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.retrieverId(model.retrieverId);
            this.configuration(model.configuration);
            this.displayName(model.displayName);
            this.roleArn(model.roleArn);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getRetrieverId() {
            return this.retrieverId;
        }

        public final void setRetrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
        }

        @Override
        public final Builder retrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
            return this;
        }

        public final RetrieverConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(RetrieverConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RetrieverConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRetrieverRequest build() {
            return new UpdateRetrieverRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRetrieverRequest> {
        public Builder applicationId(String var1);

        public Builder retrieverId(String var1);

        public Builder configuration(RetrieverConfiguration var1);

        default public Builder configuration(Consumer<RetrieverConfiguration.Builder> configuration) {
            return this.configuration((RetrieverConfiguration)((RetrieverConfiguration.Builder)RetrieverConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder displayName(String var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

