/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.MessageUsefulnessFeedback;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutFeedbackRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, PutFeedbackRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(PutFeedbackRequest.getter(PutFeedbackRequest::applicationId)).setter(PutFeedbackRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(PutFeedbackRequest.getter(PutFeedbackRequest::userId)).setter(PutFeedbackRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()}).build();
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationId").getter(PutFeedbackRequest.getter(PutFeedbackRequest::conversationId)).setter(PutFeedbackRequest.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("conversationId").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageId").getter(PutFeedbackRequest.getter(PutFeedbackRequest::messageId)).setter(PutFeedbackRequest.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageId").build()}).build();
    private static final SdkField<Instant> MESSAGE_COPIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("messageCopiedAt").getter(PutFeedbackRequest.getter(PutFeedbackRequest::messageCopiedAt)).setter(PutFeedbackRequest.setter(Builder::messageCopiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageCopiedAt").build()}).build();
    private static final SdkField<MessageUsefulnessFeedback> MESSAGE_USEFULNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("messageUsefulness").getter(PutFeedbackRequest.getter(PutFeedbackRequest::messageUsefulness)).setter(PutFeedbackRequest.setter(Builder::messageUsefulness)).constructor(MessageUsefulnessFeedback::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageUsefulness").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, USER_ID_FIELD, CONVERSATION_ID_FIELD, MESSAGE_ID_FIELD, MESSAGE_COPIED_AT_FIELD, MESSAGE_USEFULNESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("userId", USER_ID_FIELD);
            this.put("conversationId", CONVERSATION_ID_FIELD);
            this.put("messageId", MESSAGE_ID_FIELD);
            this.put("messageCopiedAt", MESSAGE_COPIED_AT_FIELD);
            this.put("messageUsefulness", MESSAGE_USEFULNESS_FIELD);
        }
    });
    private final String applicationId;
    private final String userId;
    private final String conversationId;
    private final String messageId;
    private final Instant messageCopiedAt;
    private final MessageUsefulnessFeedback messageUsefulness;

    private PutFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.userId = builder.userId;
        this.conversationId = builder.conversationId;
        this.messageId = builder.messageId;
        this.messageCopiedAt = builder.messageCopiedAt;
        this.messageUsefulness = builder.messageUsefulness;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String userId() {
        return this.userId;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final Instant messageCopiedAt() {
        return this.messageCopiedAt;
    }

    public final MessageUsefulnessFeedback messageUsefulness() {
        return this.messageUsefulness;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageCopiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageUsefulness());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFeedbackRequest)) {
            return false;
        }
        PutFeedbackRequest other = (PutFeedbackRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.conversationId(), other.conversationId()) && Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.messageCopiedAt(), other.messageCopiedAt()) && Objects.equals(this.messageUsefulness(), other.messageUsefulness());
    }

    public final String toString() {
        return ToString.builder((String)"PutFeedbackRequest").add("ApplicationId", (Object)this.applicationId()).add("UserId", (Object)this.userId()).add("ConversationId", (Object)this.conversationId()).add("MessageId", (Object)this.messageId()).add("MessageCopiedAt", (Object)this.messageCopiedAt()).add("MessageUsefulness", (Object)this.messageUsefulness()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "conversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "messageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "messageCopiedAt": {
                return Optional.ofNullable(clazz.cast(this.messageCopiedAt()));
            }
            case "messageUsefulness": {
                return Optional.ofNullable(clazz.cast(this.messageUsefulness()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutFeedbackRequest, T> g) {
        return obj -> g.apply((PutFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String userId;
        private String conversationId;
        private String messageId;
        private Instant messageCopiedAt;
        private MessageUsefulnessFeedback messageUsefulness;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFeedbackRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.userId(model.userId);
            this.conversationId(model.conversationId);
            this.messageId(model.messageId);
            this.messageCopiedAt(model.messageCopiedAt);
            this.messageUsefulness(model.messageUsefulness);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final Instant getMessageCopiedAt() {
            return this.messageCopiedAt;
        }

        public final void setMessageCopiedAt(Instant messageCopiedAt) {
            this.messageCopiedAt = messageCopiedAt;
        }

        @Override
        public final Builder messageCopiedAt(Instant messageCopiedAt) {
            this.messageCopiedAt = messageCopiedAt;
            return this;
        }

        public final MessageUsefulnessFeedback.Builder getMessageUsefulness() {
            return this.messageUsefulness != null ? this.messageUsefulness.toBuilder() : null;
        }

        public final void setMessageUsefulness(MessageUsefulnessFeedback.BuilderImpl messageUsefulness) {
            this.messageUsefulness = messageUsefulness != null ? messageUsefulness.build() : null;
        }

        @Override
        public final Builder messageUsefulness(MessageUsefulnessFeedback messageUsefulness) {
            this.messageUsefulness = messageUsefulness;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFeedbackRequest build() {
            return new PutFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutFeedbackRequest> {
        public Builder applicationId(String var1);

        public Builder userId(String var1);

        public Builder conversationId(String var1);

        public Builder messageId(String var1);

        public Builder messageCopiedAt(Instant var1);

        public Builder messageUsefulness(MessageUsefulnessFeedback var1);

        default public Builder messageUsefulness(Consumer<MessageUsefulnessFeedback.Builder> messageUsefulness) {
            return this.messageUsefulness((MessageUsefulnessFeedback)((MessageUsefulnessFeedback.Builder)MessageUsefulnessFeedback.builder().applyMutation(messageUsefulness)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

