/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.MembershipType;
import software.amazon.awssdk.services.qbusiness.model.ReadAccessType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrincipalGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrincipalGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PrincipalGroup.getter(PrincipalGroup::name)).setter(PrincipalGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("access").getter(PrincipalGroup.getter(PrincipalGroup::accessAsString)).setter(PrincipalGroup.setter(Builder::access)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("access").build()}).build();
    private static final SdkField<String> MEMBERSHIP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipType").getter(PrincipalGroup.getter(PrincipalGroup::membershipTypeAsString)).setter(PrincipalGroup.setter(Builder::membershipType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ACCESS_FIELD, MEMBERSHIP_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("access", ACCESS_FIELD);
            this.put("membershipType", MEMBERSHIP_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String access;
    private final String membershipType;

    private PrincipalGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.access = builder.access;
        this.membershipType = builder.membershipType;
    }

    public final String name() {
        return this.name;
    }

    public final ReadAccessType access() {
        return ReadAccessType.fromValue(this.access);
    }

    public final String accessAsString() {
        return this.access;
    }

    public final MembershipType membershipType() {
        return MembershipType.fromValue(this.membershipType);
    }

    public final String membershipTypeAsString() {
        return this.membershipType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalGroup)) {
            return false;
        }
        PrincipalGroup other = (PrincipalGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.accessAsString(), other.accessAsString()) && Objects.equals(this.membershipTypeAsString(), other.membershipTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PrincipalGroup").add("Name", (Object)this.name()).add("Access", (Object)this.accessAsString()).add("MembershipType", (Object)this.membershipTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "access": {
                return Optional.ofNullable(clazz.cast(this.accessAsString()));
            }
            case "membershipType": {
                return Optional.ofNullable(clazz.cast(this.membershipTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PrincipalGroup, T> g) {
        return obj -> g.apply((PrincipalGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String access;
        private String membershipType;

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalGroup model) {
            this.name(model.name);
            this.access(model.access);
            this.membershipType(model.membershipType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAccess() {
            return this.access;
        }

        public final void setAccess(String access) {
            this.access = access;
        }

        @Override
        public final Builder access(String access) {
            this.access = access;
            return this;
        }

        @Override
        public final Builder access(ReadAccessType access) {
            this.access(access == null ? null : access.toString());
            return this;
        }

        public final String getMembershipType() {
            return this.membershipType;
        }

        public final void setMembershipType(String membershipType) {
            this.membershipType = membershipType;
        }

        @Override
        public final Builder membershipType(String membershipType) {
            this.membershipType = membershipType;
            return this;
        }

        @Override
        public final Builder membershipType(MembershipType membershipType) {
            this.membershipType(membershipType == null ? null : membershipType.toString());
            return this;
        }

        public PrincipalGroup build() {
            return new PrincipalGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrincipalGroup> {
        public Builder name(String var1);

        public Builder access(String var1);

        public Builder access(ReadAccessType var1);

        public Builder membershipType(String var1);

        public Builder membershipType(MembershipType var1);
    }
}

