/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeBoostingLevel;
import software.amazon.awssdk.services.qbusiness.model.NumberAttributeBoostingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NumberAttributeBoostingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NumberAttributeBoostingConfiguration> {
    private static final SdkField<String> BOOSTING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("boostingLevel").getter(NumberAttributeBoostingConfiguration.getter(NumberAttributeBoostingConfiguration::boostingLevelAsString)).setter(NumberAttributeBoostingConfiguration.setter(Builder::boostingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingLevel").build()}).build();
    private static final SdkField<String> BOOSTING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("boostingType").getter(NumberAttributeBoostingConfiguration.getter(NumberAttributeBoostingConfiguration::boostingTypeAsString)).setter(NumberAttributeBoostingConfiguration.setter(Builder::boostingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOSTING_LEVEL_FIELD, BOOSTING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("boostingLevel", BOOSTING_LEVEL_FIELD);
            this.put("boostingType", BOOSTING_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String boostingLevel;
    private final String boostingType;

    private NumberAttributeBoostingConfiguration(BuilderImpl builder) {
        this.boostingLevel = builder.boostingLevel;
        this.boostingType = builder.boostingType;
    }

    public final DocumentAttributeBoostingLevel boostingLevel() {
        return DocumentAttributeBoostingLevel.fromValue(this.boostingLevel);
    }

    public final String boostingLevelAsString() {
        return this.boostingLevel;
    }

    public final NumberAttributeBoostingType boostingType() {
        return NumberAttributeBoostingType.fromValue(this.boostingType);
    }

    public final String boostingTypeAsString() {
        return this.boostingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boostingLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.boostingTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberAttributeBoostingConfiguration)) {
            return false;
        }
        NumberAttributeBoostingConfiguration other = (NumberAttributeBoostingConfiguration)obj;
        return Objects.equals(this.boostingLevelAsString(), other.boostingLevelAsString()) && Objects.equals(this.boostingTypeAsString(), other.boostingTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NumberAttributeBoostingConfiguration").add("BoostingLevel", (Object)this.boostingLevelAsString()).add("BoostingType", (Object)this.boostingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "boostingLevel": {
                return Optional.ofNullable(clazz.cast(this.boostingLevelAsString()));
            }
            case "boostingType": {
                return Optional.ofNullable(clazz.cast(this.boostingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NumberAttributeBoostingConfiguration, T> g) {
        return obj -> g.apply((NumberAttributeBoostingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String boostingLevel;
        private String boostingType;

        private BuilderImpl() {
        }

        private BuilderImpl(NumberAttributeBoostingConfiguration model) {
            this.boostingLevel(model.boostingLevel);
            this.boostingType(model.boostingType);
        }

        public final String getBoostingLevel() {
            return this.boostingLevel;
        }

        public final void setBoostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
        }

        @Override
        public final Builder boostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
            return this;
        }

        @Override
        public final Builder boostingLevel(DocumentAttributeBoostingLevel boostingLevel) {
            this.boostingLevel(boostingLevel == null ? null : boostingLevel.toString());
            return this;
        }

        public final String getBoostingType() {
            return this.boostingType;
        }

        public final void setBoostingType(String boostingType) {
            this.boostingType = boostingType;
        }

        @Override
        public final Builder boostingType(String boostingType) {
            this.boostingType = boostingType;
            return this;
        }

        @Override
        public final Builder boostingType(NumberAttributeBoostingType boostingType) {
            this.boostingType(boostingType == null ? null : boostingType.toString());
            return this;
        }

        public NumberAttributeBoostingConfiguration build() {
            return new NumberAttributeBoostingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NumberAttributeBoostingConfiguration> {
        public Builder boostingLevel(String var1);

        public Builder boostingLevel(DocumentAttributeBoostingLevel var1);

        public Builder boostingType(String var1);

        public Builder boostingType(NumberAttributeBoostingType var1);
    }
}

