/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.DataSourceSyncJob;
import software.amazon.awssdk.services.qbusiness.model.DataSourceSyncJobsCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSourceSyncJobsResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, ListDataSourceSyncJobsResponse> {
    private static final SdkField<List<DataSourceSyncJob>> HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("history").getter(ListDataSourceSyncJobsResponse.getter(ListDataSourceSyncJobsResponse::history)).setter(ListDataSourceSyncJobsResponse.setter(Builder::history)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("history").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceSyncJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataSourceSyncJobsResponse.getter(ListDataSourceSyncJobsResponse::nextToken)).setter(ListDataSourceSyncJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HISTORY_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("history", HISTORY_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<DataSourceSyncJob> history;
    private final String nextToken;

    private ListDataSourceSyncJobsResponse(BuilderImpl builder) {
        super(builder);
        this.history = builder.history;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasHistory() {
        return this.history != null && !(this.history instanceof SdkAutoConstructList);
    }

    public final List<DataSourceSyncJob> history() {
        return this.history;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHistory() ? this.history() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourceSyncJobsResponse)) {
            return false;
        }
        ListDataSourceSyncJobsResponse other = (ListDataSourceSyncJobsResponse)((Object)obj);
        return this.hasHistory() == other.hasHistory() && Objects.equals(this.history(), other.history()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataSourceSyncJobsResponse").add("History", this.hasHistory() ? this.history() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "history": {
                return Optional.ofNullable(clazz.cast(this.history()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSourceSyncJobsResponse, T> g) {
        return obj -> g.apply((ListDataSourceSyncJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private List<DataSourceSyncJob> history = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourceSyncJobsResponse model) {
            super(model);
            this.history(model.history);
            this.nextToken(model.nextToken);
        }

        public final List<DataSourceSyncJob.Builder> getHistory() {
            List<DataSourceSyncJob.Builder> result = DataSourceSyncJobsCopier.copyToBuilder(this.history);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHistory(Collection<DataSourceSyncJob.BuilderImpl> history) {
            this.history = DataSourceSyncJobsCopier.copyFromBuilder(history);
        }

        @Override
        public final Builder history(Collection<DataSourceSyncJob> history) {
            this.history = DataSourceSyncJobsCopier.copy(history);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(DataSourceSyncJob ... history) {
            this.history(Arrays.asList(history));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(Consumer<DataSourceSyncJob.Builder> ... history) {
            this.history(Stream.of(history).map(c -> (DataSourceSyncJob)((DataSourceSyncJob.Builder)DataSourceSyncJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataSourceSyncJobsResponse build() {
            return new ListDataSourceSyncJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataSourceSyncJobsResponse> {
        public Builder history(Collection<DataSourceSyncJob> var1);

        public Builder history(DataSourceSyncJob ... var1);

        public Builder history(Consumer<DataSourceSyncJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

