/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.services.qbusiness.model.RetrieverConfiguration;
import software.amazon.awssdk.services.qbusiness.model.RetrieverStatus;
import software.amazon.awssdk.services.qbusiness.model.RetrieverType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRetrieverResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, GetRetrieverResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(GetRetrieverResponse.getter(GetRetrieverResponse::applicationId)).setter(GetRetrieverResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> RETRIEVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retrieverId").getter(GetRetrieverResponse.getter(GetRetrieverResponse::retrieverId)).setter(GetRetrieverResponse.setter(Builder::retrieverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieverId").build()}).build();
    private static final SdkField<String> RETRIEVER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retrieverArn").getter(GetRetrieverResponse.getter(GetRetrieverResponse::retrieverArn)).setter(GetRetrieverResponse.setter(Builder::retrieverArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieverArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetRetrieverResponse.getter(GetRetrieverResponse::typeAsString)).setter(GetRetrieverResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetRetrieverResponse.getter(GetRetrieverResponse::statusAsString)).setter(GetRetrieverResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetRetrieverResponse.getter(GetRetrieverResponse::displayName)).setter(GetRetrieverResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<RetrieverConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(GetRetrieverResponse.getter(GetRetrieverResponse::configuration)).setter(GetRetrieverResponse.setter(Builder::configuration)).constructor(RetrieverConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetRetrieverResponse.getter(GetRetrieverResponse::roleArn)).setter(GetRetrieverResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetRetrieverResponse.getter(GetRetrieverResponse::createdAt)).setter(GetRetrieverResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetRetrieverResponse.getter(GetRetrieverResponse::updatedAt)).setter(GetRetrieverResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, RETRIEVER_ID_FIELD, RETRIEVER_ARN_FIELD, TYPE_FIELD, STATUS_FIELD, DISPLAY_NAME_FIELD, CONFIGURATION_FIELD, ROLE_ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("retrieverId", RETRIEVER_ID_FIELD);
            this.put("retrieverArn", RETRIEVER_ARN_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
        }
    });
    private final String applicationId;
    private final String retrieverId;
    private final String retrieverArn;
    private final String type;
    private final String status;
    private final String displayName;
    private final RetrieverConfiguration configuration;
    private final String roleArn;
    private final Instant createdAt;
    private final Instant updatedAt;

    private GetRetrieverResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.retrieverId = builder.retrieverId;
        this.retrieverArn = builder.retrieverArn;
        this.type = builder.type;
        this.status = builder.status;
        this.displayName = builder.displayName;
        this.configuration = builder.configuration;
        this.roleArn = builder.roleArn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String retrieverId() {
        return this.retrieverId;
    }

    public final String retrieverArn() {
        return this.retrieverArn;
    }

    public final RetrieverType type() {
        return RetrieverType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final RetrieverStatus status() {
        return RetrieverStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final RetrieverConfiguration configuration() {
        return this.configuration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieverArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRetrieverResponse)) {
            return false;
        }
        GetRetrieverResponse other = (GetRetrieverResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.retrieverId(), other.retrieverId()) && Objects.equals(this.retrieverArn(), other.retrieverArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetRetrieverResponse").add("ApplicationId", (Object)this.applicationId()).add("RetrieverId", (Object)this.retrieverId()).add("RetrieverArn", (Object)this.retrieverArn()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("DisplayName", (Object)this.displayName()).add("Configuration", (Object)this.configuration()).add("RoleArn", (Object)this.roleArn()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "retrieverId": {
                return Optional.ofNullable(clazz.cast(this.retrieverId()));
            }
            case "retrieverArn": {
                return Optional.ofNullable(clazz.cast(this.retrieverArn()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRetrieverResponse, T> g) {
        return obj -> g.apply((GetRetrieverResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String retrieverId;
        private String retrieverArn;
        private String type;
        private String status;
        private String displayName;
        private RetrieverConfiguration configuration;
        private String roleArn;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRetrieverResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.retrieverId(model.retrieverId);
            this.retrieverArn(model.retrieverArn);
            this.type(model.type);
            this.status(model.status);
            this.displayName(model.displayName);
            this.configuration(model.configuration);
            this.roleArn(model.roleArn);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getRetrieverId() {
            return this.retrieverId;
        }

        public final void setRetrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
        }

        @Override
        public final Builder retrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
            return this;
        }

        public final String getRetrieverArn() {
            return this.retrieverArn;
        }

        public final void setRetrieverArn(String retrieverArn) {
            this.retrieverArn = retrieverArn;
        }

        @Override
        public final Builder retrieverArn(String retrieverArn) {
            this.retrieverArn = retrieverArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrieverType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RetrieverStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final RetrieverConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(RetrieverConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RetrieverConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetRetrieverResponse build() {
            return new GetRetrieverResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRetrieverResponse> {
        public Builder applicationId(String var1);

        public Builder retrieverId(String var1);

        public Builder retrieverArn(String var1);

        public Builder type(String var1);

        public Builder type(RetrieverType var1);

        public Builder status(String var1);

        public Builder status(RetrieverStatus var1);

        public Builder displayName(String var1);

        public Builder configuration(RetrieverConfiguration var1);

        default public Builder configuration(Consumer<RetrieverConfiguration.Builder> configuration) {
            return this.configuration((RetrieverConfiguration)((RetrieverConfiguration.Builder)RetrieverConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder roleArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

