/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.services.qbusiness.model.DocumentEnrichmentConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.Tag;
import software.amazon.awssdk.services.qbusiness.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSourceRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, CreateDataSourceRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::applicationId)).setter(CreateDataSourceRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexId").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::indexId)).setter(CreateDataSourceRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::displayName)).setter(CreateDataSourceRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<Document> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("configuration").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::configuration)).setter(CreateDataSourceRequest.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfiguration").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::vpcConfiguration)).setter(CreateDataSourceRequest.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::description)).setter(CreateDataSourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::tags)).setter(CreateDataSourceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SYNC_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncSchedule").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::syncSchedule)).setter(CreateDataSourceRequest.setter(Builder::syncSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSchedule").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::roleArn)).setter(CreateDataSourceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::clientToken)).setter(CreateDataSourceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<DocumentEnrichmentConfiguration> DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentEnrichmentConfiguration").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::documentEnrichmentConfiguration)).setter(CreateDataSourceRequest.setter(Builder::documentEnrichmentConfiguration)).constructor(DocumentEnrichmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentEnrichmentConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, INDEX_ID_FIELD, DISPLAY_NAME_FIELD, CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, SYNC_SCHEDULE_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("indexId", INDEX_ID_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("syncSchedule", SYNC_SCHEDULE_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("documentEnrichmentConfiguration", DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD);
        }
    });
    private final String applicationId;
    private final String indexId;
    private final String displayName;
    private final Document configuration;
    private final DataSourceVpcConfiguration vpcConfiguration;
    private final String description;
    private final List<Tag> tags;
    private final String syncSchedule;
    private final String roleArn;
    private final String clientToken;
    private final DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

    private CreateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.displayName = builder.displayName;
        this.configuration = builder.configuration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.description = builder.description;
        this.tags = builder.tags;
        this.syncSchedule = builder.syncSchedule;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
        this.documentEnrichmentConfiguration = builder.documentEnrichmentConfiguration;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final Document configuration() {
        return this.configuration;
    }

    public final DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String syncSchedule() {
        return this.syncSchedule;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DocumentEnrichmentConfiguration documentEnrichmentConfiguration() {
        return this.documentEnrichmentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentEnrichmentConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.syncSchedule(), other.syncSchedule()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.documentEnrichmentConfiguration(), other.documentEnrichmentConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataSourceRequest").add("ApplicationId", (Object)this.applicationId()).add("IndexId", (Object)this.indexId()).add("DisplayName", (Object)this.displayName()).add("Configuration", (Object)this.configuration()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("SyncSchedule", (Object)this.syncSchedule()).add("RoleArn", (Object)this.roleArn()).add("ClientToken", (Object)this.clientToken()).add("DocumentEnrichmentConfiguration", (Object)this.documentEnrichmentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "indexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "vpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "syncSchedule": {
                return Optional.ofNullable(clazz.cast(this.syncSchedule()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "documentEnrichmentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.documentEnrichmentConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceRequest, T> g) {
        return obj -> g.apply((CreateDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String indexId;
        private String displayName;
        private Document configuration;
        private DataSourceVpcConfiguration vpcConfiguration;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String syncSchedule;
        private String roleArn;
        private String clientToken;
        private DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.indexId(model.indexId);
            this.displayName(model.displayName);
            this.configuration(model.configuration);
            this.vpcConfiguration(model.vpcConfiguration);
            this.description(model.description);
            this.tags(model.tags);
            this.syncSchedule(model.syncSchedule);
            this.roleArn(model.roleArn);
            this.clientToken(model.clientToken);
            this.documentEnrichmentConfiguration(model.documentEnrichmentConfiguration);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Document getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(Document configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(Document configuration) {
            this.configuration = configuration;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSyncSchedule() {
            return this.syncSchedule;
        }

        public final void setSyncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
        }

        @Override
        public final Builder syncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DocumentEnrichmentConfiguration.Builder getDocumentEnrichmentConfiguration() {
            return this.documentEnrichmentConfiguration != null ? this.documentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setDocumentEnrichmentConfiguration(DocumentEnrichmentConfiguration.BuilderImpl documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration.build() : null;
        }

        @Override
        public final Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataSourceRequest> {
        public Builder applicationId(String var1);

        public Builder indexId(String var1);

        public Builder displayName(String var1);

        public Builder configuration(Document var1);

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder syncSchedule(String var1);

        public Builder roleArn(String var1);

        public Builder clientToken(String var1);

        public Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration var1);

        default public Builder documentEnrichmentConfiguration(Consumer<DocumentEnrichmentConfiguration.Builder> documentEnrichmentConfiguration) {
            return this.documentEnrichmentConfiguration((DocumentEnrichmentConfiguration)((DocumentEnrichmentConfiguration.Builder)DocumentEnrichmentConfiguration.builder().applyMutation(documentEnrichmentConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

