/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.BlockedPhrasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlockedPhrasesConfigurationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlockedPhrasesConfigurationUpdate> {
    private static final SdkField<List<String>> BLOCKED_PHRASES_TO_CREATE_OR_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockedPhrasesToCreateOrUpdate").getter(BlockedPhrasesConfigurationUpdate.getter(BlockedPhrasesConfigurationUpdate::blockedPhrasesToCreateOrUpdate)).setter(BlockedPhrasesConfigurationUpdate.setter(Builder::blockedPhrasesToCreateOrUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedPhrasesToCreateOrUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BLOCKED_PHRASES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockedPhrasesToDelete").getter(BlockedPhrasesConfigurationUpdate.getter(BlockedPhrasesConfigurationUpdate::blockedPhrasesToDelete)).setter(BlockedPhrasesConfigurationUpdate.setter(Builder::blockedPhrasesToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedPhrasesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SYSTEM_MESSAGE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemMessageOverride").getter(BlockedPhrasesConfigurationUpdate.getter(BlockedPhrasesConfigurationUpdate::systemMessageOverride)).setter(BlockedPhrasesConfigurationUpdate.setter(Builder::systemMessageOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_PHRASES_TO_CREATE_OR_UPDATE_FIELD, BLOCKED_PHRASES_TO_DELETE_FIELD, SYSTEM_MESSAGE_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("blockedPhrasesToCreateOrUpdate", BLOCKED_PHRASES_TO_CREATE_OR_UPDATE_FIELD);
            this.put("blockedPhrasesToDelete", BLOCKED_PHRASES_TO_DELETE_FIELD);
            this.put("systemMessageOverride", SYSTEM_MESSAGE_OVERRIDE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> blockedPhrasesToCreateOrUpdate;
    private final List<String> blockedPhrasesToDelete;
    private final String systemMessageOverride;

    private BlockedPhrasesConfigurationUpdate(BuilderImpl builder) {
        this.blockedPhrasesToCreateOrUpdate = builder.blockedPhrasesToCreateOrUpdate;
        this.blockedPhrasesToDelete = builder.blockedPhrasesToDelete;
        this.systemMessageOverride = builder.systemMessageOverride;
    }

    public final boolean hasBlockedPhrasesToCreateOrUpdate() {
        return this.blockedPhrasesToCreateOrUpdate != null && !(this.blockedPhrasesToCreateOrUpdate instanceof SdkAutoConstructList);
    }

    public final List<String> blockedPhrasesToCreateOrUpdate() {
        return this.blockedPhrasesToCreateOrUpdate;
    }

    public final boolean hasBlockedPhrasesToDelete() {
        return this.blockedPhrasesToDelete != null && !(this.blockedPhrasesToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> blockedPhrasesToDelete() {
        return this.blockedPhrasesToDelete;
    }

    public final String systemMessageOverride() {
        return this.systemMessageOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockedPhrasesToCreateOrUpdate() ? this.blockedPhrasesToCreateOrUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockedPhrasesToDelete() ? this.blockedPhrasesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.systemMessageOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockedPhrasesConfigurationUpdate)) {
            return false;
        }
        BlockedPhrasesConfigurationUpdate other = (BlockedPhrasesConfigurationUpdate)obj;
        return this.hasBlockedPhrasesToCreateOrUpdate() == other.hasBlockedPhrasesToCreateOrUpdate() && Objects.equals(this.blockedPhrasesToCreateOrUpdate(), other.blockedPhrasesToCreateOrUpdate()) && this.hasBlockedPhrasesToDelete() == other.hasBlockedPhrasesToDelete() && Objects.equals(this.blockedPhrasesToDelete(), other.blockedPhrasesToDelete()) && Objects.equals(this.systemMessageOverride(), other.systemMessageOverride());
    }

    public final String toString() {
        return ToString.builder((String)"BlockedPhrasesConfigurationUpdate").add("BlockedPhrasesToCreateOrUpdate", this.hasBlockedPhrasesToCreateOrUpdate() ? this.blockedPhrasesToCreateOrUpdate() : null).add("BlockedPhrasesToDelete", this.hasBlockedPhrasesToDelete() ? this.blockedPhrasesToDelete() : null).add("SystemMessageOverride", (Object)this.systemMessageOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blockedPhrasesToCreateOrUpdate": {
                return Optional.ofNullable(clazz.cast(this.blockedPhrasesToCreateOrUpdate()));
            }
            case "blockedPhrasesToDelete": {
                return Optional.ofNullable(clazz.cast(this.blockedPhrasesToDelete()));
            }
            case "systemMessageOverride": {
                return Optional.ofNullable(clazz.cast(this.systemMessageOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BlockedPhrasesConfigurationUpdate, T> g) {
        return obj -> g.apply((BlockedPhrasesConfigurationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> blockedPhrasesToCreateOrUpdate = DefaultSdkAutoConstructList.getInstance();
        private List<String> blockedPhrasesToDelete = DefaultSdkAutoConstructList.getInstance();
        private String systemMessageOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockedPhrasesConfigurationUpdate model) {
            this.blockedPhrasesToCreateOrUpdate(model.blockedPhrasesToCreateOrUpdate);
            this.blockedPhrasesToDelete(model.blockedPhrasesToDelete);
            this.systemMessageOverride(model.systemMessageOverride);
        }

        public final Collection<String> getBlockedPhrasesToCreateOrUpdate() {
            if (this.blockedPhrasesToCreateOrUpdate instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blockedPhrasesToCreateOrUpdate;
        }

        public final void setBlockedPhrasesToCreateOrUpdate(Collection<String> blockedPhrasesToCreateOrUpdate) {
            this.blockedPhrasesToCreateOrUpdate = BlockedPhrasesCopier.copy(blockedPhrasesToCreateOrUpdate);
        }

        @Override
        public final Builder blockedPhrasesToCreateOrUpdate(Collection<String> blockedPhrasesToCreateOrUpdate) {
            this.blockedPhrasesToCreateOrUpdate = BlockedPhrasesCopier.copy(blockedPhrasesToCreateOrUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedPhrasesToCreateOrUpdate(String ... blockedPhrasesToCreateOrUpdate) {
            this.blockedPhrasesToCreateOrUpdate(Arrays.asList(blockedPhrasesToCreateOrUpdate));
            return this;
        }

        public final Collection<String> getBlockedPhrasesToDelete() {
            if (this.blockedPhrasesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blockedPhrasesToDelete;
        }

        public final void setBlockedPhrasesToDelete(Collection<String> blockedPhrasesToDelete) {
            this.blockedPhrasesToDelete = BlockedPhrasesCopier.copy(blockedPhrasesToDelete);
        }

        @Override
        public final Builder blockedPhrasesToDelete(Collection<String> blockedPhrasesToDelete) {
            this.blockedPhrasesToDelete = BlockedPhrasesCopier.copy(blockedPhrasesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedPhrasesToDelete(String ... blockedPhrasesToDelete) {
            this.blockedPhrasesToDelete(Arrays.asList(blockedPhrasesToDelete));
            return this;
        }

        public final String getSystemMessageOverride() {
            return this.systemMessageOverride;
        }

        public final void setSystemMessageOverride(String systemMessageOverride) {
            this.systemMessageOverride = systemMessageOverride;
        }

        @Override
        public final Builder systemMessageOverride(String systemMessageOverride) {
            this.systemMessageOverride = systemMessageOverride;
            return this;
        }

        public BlockedPhrasesConfigurationUpdate build() {
            return new BlockedPhrasesConfigurationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlockedPhrasesConfigurationUpdate> {
        public Builder blockedPhrasesToCreateOrUpdate(Collection<String> var1);

        public Builder blockedPhrasesToCreateOrUpdate(String ... var1);

        public Builder blockedPhrasesToDelete(Collection<String> var1);

        public Builder blockedPhrasesToDelete(String ... var1);

        public Builder systemMessageOverride(String var1);
    }
}

