/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.ActionReviewPayloadCopier;
import software.amazon.awssdk.services.qbusiness.model.ActionReviewPayloadField;
import software.amazon.awssdk.services.qbusiness.model.PluginType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionReview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionReview> {
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginId").getter(ActionReview.getter(ActionReview::pluginId)).setter(ActionReview.setter(Builder::pluginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()}).build();
    private static final SdkField<String> PLUGIN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginType").getter(ActionReview.getter(ActionReview::pluginTypeAsString)).setter(ActionReview.setter(Builder::pluginType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginType").build()}).build();
    private static final SdkField<Map<String, ActionReviewPayloadField>> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("payload").getter(ActionReview.getter(ActionReview::payload)).setter(ActionReview.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionReviewPayloadField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PAYLOAD_FIELD_NAME_SEPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("payloadFieldNameSeparator").getter(ActionReview.getter(ActionReview::payloadFieldNameSeparator)).setter(ActionReview.setter(Builder::payloadFieldNameSeparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadFieldNameSeparator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLUGIN_ID_FIELD, PLUGIN_TYPE_FIELD, PAYLOAD_FIELD, PAYLOAD_FIELD_NAME_SEPARATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("pluginId", PLUGIN_ID_FIELD);
            this.put("pluginType", PLUGIN_TYPE_FIELD);
            this.put("payload", PAYLOAD_FIELD);
            this.put("payloadFieldNameSeparator", PAYLOAD_FIELD_NAME_SEPARATOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String pluginId;
    private final String pluginType;
    private final Map<String, ActionReviewPayloadField> payload;
    private final String payloadFieldNameSeparator;

    private ActionReview(BuilderImpl builder) {
        this.pluginId = builder.pluginId;
        this.pluginType = builder.pluginType;
        this.payload = builder.payload;
        this.payloadFieldNameSeparator = builder.payloadFieldNameSeparator;
    }

    public final String pluginId() {
        return this.pluginId;
    }

    public final PluginType pluginType() {
        return PluginType.fromValue(this.pluginType);
    }

    public final String pluginTypeAsString() {
        return this.pluginType;
    }

    public final boolean hasPayload() {
        return this.payload != null && !(this.payload instanceof SdkAutoConstructMap);
    }

    public final Map<String, ActionReviewPayloadField> payload() {
        return this.payload;
    }

    public final String payloadFieldNameSeparator() {
        return this.payloadFieldNameSeparator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPayload() ? this.payload() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadFieldNameSeparator());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionReview)) {
            return false;
        }
        ActionReview other = (ActionReview)obj;
        return Objects.equals(this.pluginId(), other.pluginId()) && Objects.equals(this.pluginTypeAsString(), other.pluginTypeAsString()) && this.hasPayload() == other.hasPayload() && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.payloadFieldNameSeparator(), other.payloadFieldNameSeparator());
    }

    public final String toString() {
        return ToString.builder((String)"ActionReview").add("PluginId", (Object)this.pluginId()).add("PluginType", (Object)this.pluginTypeAsString()).add("Payload", this.hasPayload() ? this.payload() : null).add("PayloadFieldNameSeparator", (Object)this.payloadFieldNameSeparator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pluginId": {
                return Optional.ofNullable(clazz.cast(this.pluginId()));
            }
            case "pluginType": {
                return Optional.ofNullable(clazz.cast(this.pluginTypeAsString()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "payloadFieldNameSeparator": {
                return Optional.ofNullable(clazz.cast(this.payloadFieldNameSeparator()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ActionReview, T> g) {
        return obj -> g.apply((ActionReview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pluginId;
        private String pluginType;
        private Map<String, ActionReviewPayloadField> payload = DefaultSdkAutoConstructMap.getInstance();
        private String payloadFieldNameSeparator;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionReview model) {
            this.pluginId(model.pluginId);
            this.pluginType(model.pluginType);
            this.payload(model.payload);
            this.payloadFieldNameSeparator(model.payloadFieldNameSeparator);
        }

        public final String getPluginId() {
            return this.pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getPluginType() {
            return this.pluginType;
        }

        public final void setPluginType(String pluginType) {
            this.pluginType = pluginType;
        }

        @Override
        public final Builder pluginType(String pluginType) {
            this.pluginType = pluginType;
            return this;
        }

        @Override
        public final Builder pluginType(PluginType pluginType) {
            this.pluginType(pluginType == null ? null : pluginType.toString());
            return this;
        }

        public final Map<String, ActionReviewPayloadField.Builder> getPayload() {
            Map<String, ActionReviewPayloadField.Builder> result = ActionReviewPayloadCopier.copyToBuilder(this.payload);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPayload(Map<String, ActionReviewPayloadField.BuilderImpl> payload) {
            this.payload = ActionReviewPayloadCopier.copyFromBuilder(payload);
        }

        @Override
        public final Builder payload(Map<String, ActionReviewPayloadField> payload) {
            this.payload = ActionReviewPayloadCopier.copy(payload);
            return this;
        }

        public final String getPayloadFieldNameSeparator() {
            return this.payloadFieldNameSeparator;
        }

        public final void setPayloadFieldNameSeparator(String payloadFieldNameSeparator) {
            this.payloadFieldNameSeparator = payloadFieldNameSeparator;
        }

        @Override
        public final Builder payloadFieldNameSeparator(String payloadFieldNameSeparator) {
            this.payloadFieldNameSeparator = payloadFieldNameSeparator;
            return this;
        }

        public ActionReview build() {
            return new ActionReview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionReview> {
        public Builder pluginId(String var1);

        public Builder pluginType(String var1);

        public Builder pluginType(PluginType var1);

        public Builder payload(Map<String, ActionReviewPayloadField> var1);

        public Builder payloadFieldNameSeparator(String var1);
    }
}

