/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.FailedDocument;
import software.amazon.awssdk.services.qbusiness.model.FailedDocumentsCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteDocumentResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, BatchDeleteDocumentResponse> {
    private static final SdkField<List<FailedDocument>> FAILED_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedDocuments").getter(BatchDeleteDocumentResponse.getter(BatchDeleteDocumentResponse::failedDocuments)).setter(BatchDeleteDocumentResponse.setter(Builder::failedDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_DOCUMENTS_FIELD));
    private final List<FailedDocument> failedDocuments;

    private BatchDeleteDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.failedDocuments = builder.failedDocuments;
    }

    public final boolean hasFailedDocuments() {
        return this.failedDocuments != null && !(this.failedDocuments instanceof SdkAutoConstructList);
    }

    public final List<FailedDocument> failedDocuments() {
        return this.failedDocuments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedDocuments() ? this.failedDocuments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDocumentResponse)) {
            return false;
        }
        BatchDeleteDocumentResponse other = (BatchDeleteDocumentResponse)((Object)obj);
        return this.hasFailedDocuments() == other.hasFailedDocuments() && Objects.equals(this.failedDocuments(), other.failedDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteDocumentResponse").add("FailedDocuments", this.hasFailedDocuments() ? this.failedDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failedDocuments": {
                return Optional.ofNullable(clazz.cast(this.failedDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteDocumentResponse, T> g) {
        return obj -> g.apply((BatchDeleteDocumentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private List<FailedDocument> failedDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteDocumentResponse model) {
            super(model);
            this.failedDocuments(model.failedDocuments);
        }

        public final List<FailedDocument.Builder> getFailedDocuments() {
            List<FailedDocument.Builder> result = FailedDocumentsCopier.copyToBuilder(this.failedDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedDocuments(Collection<FailedDocument.BuilderImpl> failedDocuments) {
            this.failedDocuments = FailedDocumentsCopier.copyFromBuilder(failedDocuments);
        }

        @Override
        public final Builder failedDocuments(Collection<FailedDocument> failedDocuments) {
            this.failedDocuments = FailedDocumentsCopier.copy(failedDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDocuments(FailedDocument ... failedDocuments) {
            this.failedDocuments(Arrays.asList(failedDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDocuments(Consumer<FailedDocument.Builder> ... failedDocuments) {
            this.failedDocuments(Stream.of(failedDocuments).map(c -> (FailedDocument)((FailedDocument.Builder)FailedDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteDocumentResponse build() {
            return new BatchDeleteDocumentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteDocumentResponse> {
        public Builder failedDocuments(Collection<FailedDocument> var1);

        public Builder failedDocuments(FailedDocument ... var1);

        public Builder failedDocuments(Consumer<FailedDocument.Builder> ... var1);
    }
}

