/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.ActionPayloadFieldType;
import software.amazon.awssdk.services.qbusiness.model.ActionReviewPayloadFieldAllowedValue;
import software.amazon.awssdk.services.qbusiness.model.ActionReviewPayloadFieldAllowedValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionReviewPayloadField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionReviewPayloadField> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(ActionReviewPayloadField.getter(ActionReviewPayloadField::displayName)).setter(ActionReviewPayloadField.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<Integer> DISPLAY_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("displayOrder").getter(ActionReviewPayloadField.getter(ActionReviewPayloadField::displayOrder)).setter(ActionReviewPayloadField.setter(Builder::displayOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayOrder").build()}).build();
    private static final SdkField<String> DISPLAY_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayDescription").getter(ActionReviewPayloadField.getter(ActionReviewPayloadField::displayDescription)).setter(ActionReviewPayloadField.setter(Builder::displayDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayDescription").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ActionReviewPayloadField.getter(ActionReviewPayloadField::typeAsString)).setter(ActionReviewPayloadField.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Document> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("value").getter(ActionReviewPayloadField.getter(ActionReviewPayloadField::value)).setter(ActionReviewPayloadField.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<List<ActionReviewPayloadFieldAllowedValue>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedValues").getter(ActionReviewPayloadField.getter(ActionReviewPayloadField::allowedValues)).setter(ActionReviewPayloadField.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionReviewPayloadFieldAllowedValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ALLOWED_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("allowedFormat").getter(ActionReviewPayloadField.getter(ActionReviewPayloadField::allowedFormat)).setter(ActionReviewPayloadField.setter(Builder::allowedFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedFormat").build()}).build();
    private static final SdkField<Document> ARRAY_ITEM_JSON_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("arrayItemJsonSchema").getter(ActionReviewPayloadField.getter(ActionReviewPayloadField::arrayItemJsonSchema)).setter(ActionReviewPayloadField.setter(Builder::arrayItemJsonSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayItemJsonSchema").build()}).build();
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("required").getter(ActionReviewPayloadField.getter(ActionReviewPayloadField::required)).setter(ActionReviewPayloadField.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD, DISPLAY_ORDER_FIELD, DISPLAY_DESCRIPTION_FIELD, TYPE_FIELD, VALUE_FIELD, ALLOWED_VALUES_FIELD, ALLOWED_FORMAT_FIELD, ARRAY_ITEM_JSON_SCHEMA_FIELD, REQUIRED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String displayName;
    private final Integer displayOrder;
    private final String displayDescription;
    private final String type;
    private final Document value;
    private final List<ActionReviewPayloadFieldAllowedValue> allowedValues;
    private final String allowedFormat;
    private final Document arrayItemJsonSchema;
    private final Boolean required;

    private ActionReviewPayloadField(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.displayOrder = builder.displayOrder;
        this.displayDescription = builder.displayDescription;
        this.type = builder.type;
        this.value = builder.value;
        this.allowedValues = builder.allowedValues;
        this.allowedFormat = builder.allowedFormat;
        this.arrayItemJsonSchema = builder.arrayItemJsonSchema;
        this.required = builder.required;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final Integer displayOrder() {
        return this.displayOrder;
    }

    public final String displayDescription() {
        return this.displayDescription;
    }

    public final ActionPayloadFieldType type() {
        return ActionPayloadFieldType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Document value() {
        return this.value;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<ActionReviewPayloadFieldAllowedValue> allowedValues() {
        return this.allowedValues;
    }

    public final String allowedFormat() {
        return this.allowedFormat;
    }

    public final Document arrayItemJsonSchema() {
        return this.arrayItemJsonSchema;
    }

    public final Boolean required() {
        return this.required;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrayItemJsonSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionReviewPayloadField)) {
            return false;
        }
        ActionReviewPayloadField other = (ActionReviewPayloadField)obj;
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.displayOrder(), other.displayOrder()) && Objects.equals(this.displayDescription(), other.displayDescription()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.value(), other.value()) && this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.allowedFormat(), other.allowedFormat()) && Objects.equals(this.arrayItemJsonSchema(), other.arrayItemJsonSchema()) && Objects.equals(this.required(), other.required());
    }

    public final String toString() {
        return ToString.builder((String)"ActionReviewPayloadField").add("DisplayName", (Object)this.displayName()).add("DisplayOrder", (Object)this.displayOrder()).add("DisplayDescription", (Object)this.displayDescription()).add("Type", (Object)this.typeAsString()).add("Value", (Object)this.value()).add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).add("AllowedFormat", (Object)this.allowedFormat()).add("ArrayItemJsonSchema", (Object)this.arrayItemJsonSchema()).add("Required", (Object)this.required()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "displayOrder": {
                return Optional.ofNullable(clazz.cast(this.displayOrder()));
            }
            case "displayDescription": {
                return Optional.ofNullable(clazz.cast(this.displayDescription()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "allowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "allowedFormat": {
                return Optional.ofNullable(clazz.cast(this.allowedFormat()));
            }
            case "arrayItemJsonSchema": {
                return Optional.ofNullable(clazz.cast(this.arrayItemJsonSchema()));
            }
            case "required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionReviewPayloadField, T> g) {
        return obj -> g.apply((ActionReviewPayloadField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String displayName;
        private Integer displayOrder;
        private String displayDescription;
        private String type;
        private Document value;
        private List<ActionReviewPayloadFieldAllowedValue> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private String allowedFormat;
        private Document arrayItemJsonSchema;
        private Boolean required;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionReviewPayloadField model) {
            this.displayName(model.displayName);
            this.displayOrder(model.displayOrder);
            this.displayDescription(model.displayDescription);
            this.type(model.type);
            this.value(model.value);
            this.allowedValues(model.allowedValues);
            this.allowedFormat(model.allowedFormat);
            this.arrayItemJsonSchema(model.arrayItemJsonSchema);
            this.required(model.required);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Integer getDisplayOrder() {
            return this.displayOrder;
        }

        public final void setDisplayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
        }

        @Override
        public final Builder displayOrder(Integer displayOrder) {
            this.displayOrder = displayOrder;
            return this;
        }

        public final String getDisplayDescription() {
            return this.displayDescription;
        }

        public final void setDisplayDescription(String displayDescription) {
            this.displayDescription = displayDescription;
        }

        @Override
        public final Builder displayDescription(String displayDescription) {
            this.displayDescription = displayDescription;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionPayloadFieldType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Document getValue() {
            return this.value;
        }

        public final void setValue(Document value) {
            this.value = value;
        }

        @Override
        public final Builder value(Document value) {
            this.value = value;
            return this;
        }

        public final List<ActionReviewPayloadFieldAllowedValue.Builder> getAllowedValues() {
            List<ActionReviewPayloadFieldAllowedValue.Builder> result = ActionReviewPayloadFieldAllowedValuesCopier.copyToBuilder(this.allowedValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedValues(Collection<ActionReviewPayloadFieldAllowedValue.BuilderImpl> allowedValues) {
            this.allowedValues = ActionReviewPayloadFieldAllowedValuesCopier.copyFromBuilder(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<ActionReviewPayloadFieldAllowedValue> allowedValues) {
            this.allowedValues = ActionReviewPayloadFieldAllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(ActionReviewPayloadFieldAllowedValue ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(Consumer<ActionReviewPayloadFieldAllowedValue.Builder> ... allowedValues) {
            this.allowedValues(Stream.of(allowedValues).map(c -> (ActionReviewPayloadFieldAllowedValue)((ActionReviewPayloadFieldAllowedValue.Builder)ActionReviewPayloadFieldAllowedValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAllowedFormat() {
            return this.allowedFormat;
        }

        public final void setAllowedFormat(String allowedFormat) {
            this.allowedFormat = allowedFormat;
        }

        @Override
        public final Builder allowedFormat(String allowedFormat) {
            this.allowedFormat = allowedFormat;
            return this;
        }

        public final Document getArrayItemJsonSchema() {
            return this.arrayItemJsonSchema;
        }

        public final void setArrayItemJsonSchema(Document arrayItemJsonSchema) {
            this.arrayItemJsonSchema = arrayItemJsonSchema;
        }

        @Override
        public final Builder arrayItemJsonSchema(Document arrayItemJsonSchema) {
            this.arrayItemJsonSchema = arrayItemJsonSchema;
            return this;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public ActionReviewPayloadField build() {
            return new ActionReviewPayloadField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionReviewPayloadField> {
        public Builder displayName(String var1);

        public Builder displayOrder(Integer var1);

        public Builder displayDescription(String var1);

        public Builder type(String var1);

        public Builder type(ActionPayloadFieldType var1);

        public Builder value(Document var1);

        public Builder allowedValues(Collection<ActionReviewPayloadFieldAllowedValue> var1);

        public Builder allowedValues(ActionReviewPayloadFieldAllowedValue ... var1);

        public Builder allowedValues(Consumer<ActionReviewPayloadFieldAllowedValue.Builder> ... var1);

        public Builder allowedFormat(String var1);

        public Builder arrayItemJsonSchema(Document var1);

        public Builder required(Boolean var1);
    }
}

