/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.services.qbusiness.model.DocumentEnrichmentConfiguration;
import software.amazon.awssdk.services.qbusiness.model.MediaExtractionConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataSourceRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, UpdateDataSourceRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::applicationId)).setter(UpdateDataSourceRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexId").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::indexId)).setter(UpdateDataSourceRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::dataSourceId)).setter(UpdateDataSourceRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::displayName)).setter(UpdateDataSourceRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<Document> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("configuration").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::configuration)).setter(UpdateDataSourceRequest.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfiguration").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::vpcConfiguration)).setter(UpdateDataSourceRequest.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::description)).setter(UpdateDataSourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> SYNC_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncSchedule").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::syncSchedule)).setter(UpdateDataSourceRequest.setter(Builder::syncSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSchedule").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::roleArn)).setter(UpdateDataSourceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<DocumentEnrichmentConfiguration> DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentEnrichmentConfiguration").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::documentEnrichmentConfiguration)).setter(UpdateDataSourceRequest.setter(Builder::documentEnrichmentConfiguration)).constructor(DocumentEnrichmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentEnrichmentConfiguration").build()}).build();
    private static final SdkField<MediaExtractionConfiguration> MEDIA_EXTRACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mediaExtractionConfiguration").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::mediaExtractionConfiguration)).setter(UpdateDataSourceRequest.setter(Builder::mediaExtractionConfiguration)).constructor(MediaExtractionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaExtractionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, INDEX_ID_FIELD, DATA_SOURCE_ID_FIELD, DISPLAY_NAME_FIELD, CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD, DESCRIPTION_FIELD, SYNC_SCHEDULE_FIELD, ROLE_ARN_FIELD, DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD, MEDIA_EXTRACTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDataSourceRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String indexId;
    private final String dataSourceId;
    private final String displayName;
    private final Document configuration;
    private final DataSourceVpcConfiguration vpcConfiguration;
    private final String description;
    private final String syncSchedule;
    private final String roleArn;
    private final DocumentEnrichmentConfiguration documentEnrichmentConfiguration;
    private final MediaExtractionConfiguration mediaExtractionConfiguration;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.displayName = builder.displayName;
        this.configuration = builder.configuration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.description = builder.description;
        this.syncSchedule = builder.syncSchedule;
        this.roleArn = builder.roleArn;
        this.documentEnrichmentConfiguration = builder.documentEnrichmentConfiguration;
        this.mediaExtractionConfiguration = builder.mediaExtractionConfiguration;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final Document configuration() {
        return this.configuration;
    }

    public final DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final String syncSchedule() {
        return this.syncSchedule;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final DocumentEnrichmentConfiguration documentEnrichmentConfiguration() {
        return this.documentEnrichmentConfiguration;
    }

    public final MediaExtractionConfiguration mediaExtractionConfiguration() {
        return this.mediaExtractionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentEnrichmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaExtractionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.syncSchedule(), other.syncSchedule()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.documentEnrichmentConfiguration(), other.documentEnrichmentConfiguration()) && Objects.equals(this.mediaExtractionConfiguration(), other.mediaExtractionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataSourceRequest").add("ApplicationId", (Object)this.applicationId()).add("IndexId", (Object)this.indexId()).add("DataSourceId", (Object)this.dataSourceId()).add("DisplayName", (Object)this.displayName()).add("Configuration", (Object)this.configuration()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("Description", (Object)this.description()).add("SyncSchedule", (Object)this.syncSchedule()).add("RoleArn", (Object)this.roleArn()).add("DocumentEnrichmentConfiguration", (Object)this.documentEnrichmentConfiguration()).add("MediaExtractionConfiguration", (Object)this.mediaExtractionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "indexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "vpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "syncSchedule": {
                return Optional.ofNullable(clazz.cast(this.syncSchedule()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "documentEnrichmentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.documentEnrichmentConfiguration()));
            }
            case "mediaExtractionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.mediaExtractionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("indexId", INDEX_ID_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("syncSchedule", SYNC_SCHEDULE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("documentEnrichmentConfiguration", DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD);
        map.put("mediaExtractionConfiguration", MEDIA_EXTRACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourceRequest, T> g) {
        return obj -> g.apply((UpdateDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String indexId;
        private String dataSourceId;
        private String displayName;
        private Document configuration;
        private DataSourceVpcConfiguration vpcConfiguration;
        private String description;
        private String syncSchedule;
        private String roleArn;
        private DocumentEnrichmentConfiguration documentEnrichmentConfiguration;
        private MediaExtractionConfiguration mediaExtractionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.indexId(model.indexId);
            this.dataSourceId(model.dataSourceId);
            this.displayName(model.displayName);
            this.configuration(model.configuration);
            this.vpcConfiguration(model.vpcConfiguration);
            this.description(model.description);
            this.syncSchedule(model.syncSchedule);
            this.roleArn(model.roleArn);
            this.documentEnrichmentConfiguration(model.documentEnrichmentConfiguration);
            this.mediaExtractionConfiguration(model.mediaExtractionConfiguration);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Document getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(Document configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(Document configuration) {
            this.configuration = configuration;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSyncSchedule() {
            return this.syncSchedule;
        }

        public final void setSyncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
        }

        @Override
        public final Builder syncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DocumentEnrichmentConfiguration.Builder getDocumentEnrichmentConfiguration() {
            return this.documentEnrichmentConfiguration != null ? this.documentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setDocumentEnrichmentConfiguration(DocumentEnrichmentConfiguration.BuilderImpl documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration.build() : null;
        }

        @Override
        public final Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
            return this;
        }

        public final MediaExtractionConfiguration.Builder getMediaExtractionConfiguration() {
            return this.mediaExtractionConfiguration != null ? this.mediaExtractionConfiguration.toBuilder() : null;
        }

        public final void setMediaExtractionConfiguration(MediaExtractionConfiguration.BuilderImpl mediaExtractionConfiguration) {
            this.mediaExtractionConfiguration = mediaExtractionConfiguration != null ? mediaExtractionConfiguration.build() : null;
        }

        @Override
        public final Builder mediaExtractionConfiguration(MediaExtractionConfiguration mediaExtractionConfiguration) {
            this.mediaExtractionConfiguration = mediaExtractionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataSourceRequest> {
        public Builder applicationId(String var1);

        public Builder indexId(String var1);

        public Builder dataSourceId(String var1);

        public Builder displayName(String var1);

        public Builder configuration(Document var1);

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder syncSchedule(String var1);

        public Builder roleArn(String var1);

        public Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration var1);

        default public Builder documentEnrichmentConfiguration(Consumer<DocumentEnrichmentConfiguration.Builder> documentEnrichmentConfiguration) {
            return this.documentEnrichmentConfiguration((DocumentEnrichmentConfiguration)((DocumentEnrichmentConfiguration.Builder)DocumentEnrichmentConfiguration.builder().applyMutation(documentEnrichmentConfiguration)).build());
        }

        public Builder mediaExtractionConfiguration(MediaExtractionConfiguration var1);

        default public Builder mediaExtractionConfiguration(Consumer<MediaExtractionConfiguration.Builder> mediaExtractionConfiguration) {
            return this.mediaExtractionConfiguration((MediaExtractionConfiguration)((MediaExtractionConfiguration.Builder)MediaExtractionConfiguration.builder().applyMutation(mediaExtractionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

