/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuth2ClientCredentialConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuth2ClientCredentialConfiguration> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretArn").getter(OAuth2ClientCredentialConfiguration.getter(OAuth2ClientCredentialConfiguration::secretArn)).setter(OAuth2ClientCredentialConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(OAuth2ClientCredentialConfiguration.getter(OAuth2ClientCredentialConfiguration::roleArn)).setter(OAuth2ClientCredentialConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> AUTHORIZATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationUrl").getter(OAuth2ClientCredentialConfiguration.getter(OAuth2ClientCredentialConfiguration::authorizationUrl)).setter(OAuth2ClientCredentialConfiguration.setter(Builder::authorizationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationUrl").build()}).build();
    private static final SdkField<String> TOKEN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenUrl").getter(OAuth2ClientCredentialConfiguration.getter(OAuth2ClientCredentialConfiguration::tokenUrl)).setter(OAuth2ClientCredentialConfiguration.setter(Builder::tokenUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD, ROLE_ARN_FIELD, AUTHORIZATION_URL_FIELD, TOKEN_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("secretArn", SECRET_ARN_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("authorizationUrl", AUTHORIZATION_URL_FIELD);
            this.put("tokenUrl", TOKEN_URL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String secretArn;
    private final String roleArn;
    private final String authorizationUrl;
    private final String tokenUrl;

    private OAuth2ClientCredentialConfiguration(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.roleArn = builder.roleArn;
        this.authorizationUrl = builder.authorizationUrl;
        this.tokenUrl = builder.tokenUrl;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String authorizationUrl() {
        return this.authorizationUrl;
    }

    public final String tokenUrl() {
        return this.tokenUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2ClientCredentialConfiguration)) {
            return false;
        }
        OAuth2ClientCredentialConfiguration other = (OAuth2ClientCredentialConfiguration)obj;
        return Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.authorizationUrl(), other.authorizationUrl()) && Objects.equals(this.tokenUrl(), other.tokenUrl());
    }

    public final String toString() {
        return ToString.builder((String)"OAuth2ClientCredentialConfiguration").add("SecretArn", (Object)this.secretArn()).add("RoleArn", (Object)this.roleArn()).add("AuthorizationUrl", (Object)this.authorizationUrl()).add("TokenUrl", (Object)this.tokenUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "secretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "authorizationUrl": {
                return Optional.ofNullable(clazz.cast(this.authorizationUrl()));
            }
            case "tokenUrl": {
                return Optional.ofNullable(clazz.cast(this.tokenUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OAuth2ClientCredentialConfiguration, T> g) {
        return obj -> g.apply((OAuth2ClientCredentialConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String secretArn;
        private String roleArn;
        private String authorizationUrl;
        private String tokenUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2ClientCredentialConfiguration model) {
            this.secretArn(model.secretArn);
            this.roleArn(model.roleArn);
            this.authorizationUrl(model.authorizationUrl);
            this.tokenUrl(model.tokenUrl);
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getAuthorizationUrl() {
            return this.authorizationUrl;
        }

        public final void setAuthorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
        }

        @Override
        public final Builder authorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
            return this;
        }

        public final String getTokenUrl() {
            return this.tokenUrl;
        }

        public final void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        @Override
        public final Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public OAuth2ClientCredentialConfiguration build() {
            return new OAuth2ClientCredentialConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuth2ClientCredentialConfiguration> {
        public Builder secretArn(String var1);

        public Builder roleArn(String var1);

        public Builder authorizationUrl(String var1);

        public Builder tokenUrl(String var1);
    }
}

