/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMediaResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, GetMediaResponse> {
    private static final SdkField<SdkBytes> MEDIA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("mediaBytes").getter(GetMediaResponse.getter(GetMediaResponse::mediaBytes)).setter(GetMediaResponse.setter(Builder::mediaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaBytes").build()}).build();
    private static final SdkField<String> MEDIA_MIME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mediaMimeType").getter(GetMediaResponse.getter(GetMediaResponse::mediaMimeType)).setter(GetMediaResponse.setter(Builder::mediaMimeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaMimeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_BYTES_FIELD, MEDIA_MIME_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("mediaBytes", MEDIA_BYTES_FIELD);
            this.put("mediaMimeType", MEDIA_MIME_TYPE_FIELD);
        }
    });
    private final SdkBytes mediaBytes;
    private final String mediaMimeType;

    private GetMediaResponse(BuilderImpl builder) {
        super(builder);
        this.mediaBytes = builder.mediaBytes;
        this.mediaMimeType = builder.mediaMimeType;
    }

    public final SdkBytes mediaBytes() {
        return this.mediaBytes;
    }

    public final String mediaMimeType() {
        return this.mediaMimeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaMimeType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMediaResponse)) {
            return false;
        }
        GetMediaResponse other = (GetMediaResponse)((Object)obj);
        return Objects.equals(this.mediaBytes(), other.mediaBytes()) && Objects.equals(this.mediaMimeType(), other.mediaMimeType());
    }

    public final String toString() {
        return ToString.builder((String)"GetMediaResponse").add("MediaBytes", (Object)this.mediaBytes()).add("MediaMimeType", (Object)this.mediaMimeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mediaBytes": {
                return Optional.ofNullable(clazz.cast(this.mediaBytes()));
            }
            case "mediaMimeType": {
                return Optional.ofNullable(clazz.cast(this.mediaMimeType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMediaResponse, T> g) {
        return obj -> g.apply((GetMediaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private SdkBytes mediaBytes;
        private String mediaMimeType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMediaResponse model) {
            super(model);
            this.mediaBytes(model.mediaBytes);
            this.mediaMimeType(model.mediaMimeType);
        }

        public final ByteBuffer getMediaBytes() {
            return this.mediaBytes == null ? null : this.mediaBytes.asByteBuffer();
        }

        public final void setMediaBytes(ByteBuffer mediaBytes) {
            this.mediaBytes(mediaBytes == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)mediaBytes));
        }

        @Override
        public final Builder mediaBytes(SdkBytes mediaBytes) {
            this.mediaBytes = mediaBytes;
            return this;
        }

        public final String getMediaMimeType() {
            return this.mediaMimeType;
        }

        public final void setMediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
        }

        @Override
        public final Builder mediaMimeType(String mediaMimeType) {
            this.mediaMimeType = mediaMimeType;
            return this;
        }

        @Override
        public GetMediaResponse build() {
            return new GetMediaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMediaResponse> {
        public Builder mediaBytes(SdkBytes var1);

        public Builder mediaMimeType(String var1);
    }
}

