/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.BrowserExtensionConfiguration;
import software.amazon.awssdk.services.qbusiness.model.CustomizationConfiguration;
import software.amazon.awssdk.services.qbusiness.model.IdentityProviderConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.Tag;
import software.amazon.awssdk.services.qbusiness.model.TagsCopier;
import software.amazon.awssdk.services.qbusiness.model.WebExperienceOriginsCopier;
import software.amazon.awssdk.services.qbusiness.model.WebExperienceSamplePromptsControlMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWebExperienceRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, CreateWebExperienceRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::applicationId)).setter(CreateWebExperienceRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::title)).setter(CreateWebExperienceRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> SUBTITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subtitle").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::subtitle)).setter(CreateWebExperienceRequest.setter(Builder::subtitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtitle").build()}).build();
    private static final SdkField<String> WELCOME_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("welcomeMessage").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::welcomeMessage)).setter(CreateWebExperienceRequest.setter(Builder::welcomeMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("welcomeMessage").build()}).build();
    private static final SdkField<String> SAMPLE_PROMPTS_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("samplePromptsControlMode").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::samplePromptsControlModeAsString)).setter(CreateWebExperienceRequest.setter(Builder::samplePromptsControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplePromptsControlMode").build()}).build();
    private static final SdkField<List<String>> ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("origins").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::origins)).setter(CreateWebExperienceRequest.setter(Builder::origins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::roleArn)).setter(CreateWebExperienceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::tags)).setter(CreateWebExperienceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::clientToken)).setter(CreateWebExperienceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<IdentityProviderConfiguration> IDENTITY_PROVIDER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("identityProviderConfiguration").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::identityProviderConfiguration)).setter(CreateWebExperienceRequest.setter(Builder::identityProviderConfiguration)).constructor(IdentityProviderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfiguration").build()}).build();
    private static final SdkField<BrowserExtensionConfiguration> BROWSER_EXTENSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("browserExtensionConfiguration").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::browserExtensionConfiguration)).setter(CreateWebExperienceRequest.setter(Builder::browserExtensionConfiguration)).constructor(BrowserExtensionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserExtensionConfiguration").build()}).build();
    private static final SdkField<CustomizationConfiguration> CUSTOMIZATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customizationConfiguration").getter(CreateWebExperienceRequest.getter(CreateWebExperienceRequest::customizationConfiguration)).setter(CreateWebExperienceRequest.setter(Builder::customizationConfiguration)).constructor(CustomizationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, TITLE_FIELD, SUBTITLE_FIELD, WELCOME_MESSAGE_FIELD, SAMPLE_PROMPTS_CONTROL_MODE_FIELD, ORIGINS_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, IDENTITY_PROVIDER_CONFIGURATION_FIELD, BROWSER_EXTENSION_CONFIGURATION_FIELD, CUSTOMIZATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("title", TITLE_FIELD);
            this.put("subtitle", SUBTITLE_FIELD);
            this.put("welcomeMessage", WELCOME_MESSAGE_FIELD);
            this.put("samplePromptsControlMode", SAMPLE_PROMPTS_CONTROL_MODE_FIELD);
            this.put("origins", ORIGINS_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("identityProviderConfiguration", IDENTITY_PROVIDER_CONFIGURATION_FIELD);
            this.put("browserExtensionConfiguration", BROWSER_EXTENSION_CONFIGURATION_FIELD);
            this.put("customizationConfiguration", CUSTOMIZATION_CONFIGURATION_FIELD);
        }
    });
    private final String applicationId;
    private final String title;
    private final String subtitle;
    private final String welcomeMessage;
    private final String samplePromptsControlMode;
    private final List<String> origins;
    private final String roleArn;
    private final List<Tag> tags;
    private final String clientToken;
    private final IdentityProviderConfiguration identityProviderConfiguration;
    private final BrowserExtensionConfiguration browserExtensionConfiguration;
    private final CustomizationConfiguration customizationConfiguration;

    private CreateWebExperienceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.welcomeMessage = builder.welcomeMessage;
        this.samplePromptsControlMode = builder.samplePromptsControlMode;
        this.origins = builder.origins;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.identityProviderConfiguration = builder.identityProviderConfiguration;
        this.browserExtensionConfiguration = builder.browserExtensionConfiguration;
        this.customizationConfiguration = builder.customizationConfiguration;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String title() {
        return this.title;
    }

    public final String subtitle() {
        return this.subtitle;
    }

    public final String welcomeMessage() {
        return this.welcomeMessage;
    }

    public final WebExperienceSamplePromptsControlMode samplePromptsControlMode() {
        return WebExperienceSamplePromptsControlMode.fromValue(this.samplePromptsControlMode);
    }

    public final String samplePromptsControlModeAsString() {
        return this.samplePromptsControlMode;
    }

    public final boolean hasOrigins() {
        return this.origins != null && !(this.origins instanceof SdkAutoConstructList);
    }

    public final List<String> origins() {
        return this.origins;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final IdentityProviderConfiguration identityProviderConfiguration() {
        return this.identityProviderConfiguration;
    }

    public final BrowserExtensionConfiguration browserExtensionConfiguration() {
        return this.browserExtensionConfiguration;
    }

    public final CustomizationConfiguration customizationConfiguration() {
        return this.customizationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.welcomeMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplePromptsControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrigins() ? this.origins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserExtensionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebExperienceRequest)) {
            return false;
        }
        CreateWebExperienceRequest other = (CreateWebExperienceRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.subtitle(), other.subtitle()) && Objects.equals(this.welcomeMessage(), other.welcomeMessage()) && Objects.equals(this.samplePromptsControlModeAsString(), other.samplePromptsControlModeAsString()) && this.hasOrigins() == other.hasOrigins() && Objects.equals(this.origins(), other.origins()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.identityProviderConfiguration(), other.identityProviderConfiguration()) && Objects.equals(this.browserExtensionConfiguration(), other.browserExtensionConfiguration()) && Objects.equals(this.customizationConfiguration(), other.customizationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWebExperienceRequest").add("ApplicationId", (Object)this.applicationId()).add("Title", (Object)this.title()).add("Subtitle", (Object)this.subtitle()).add("WelcomeMessage", (Object)this.welcomeMessage()).add("SamplePromptsControlMode", (Object)this.samplePromptsControlModeAsString()).add("Origins", this.hasOrigins() ? this.origins() : null).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).add("IdentityProviderConfiguration", (Object)this.identityProviderConfiguration()).add("BrowserExtensionConfiguration", (Object)this.browserExtensionConfiguration()).add("CustomizationConfiguration", (Object)this.customizationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "subtitle": {
                return Optional.ofNullable(clazz.cast(this.subtitle()));
            }
            case "welcomeMessage": {
                return Optional.ofNullable(clazz.cast(this.welcomeMessage()));
            }
            case "samplePromptsControlMode": {
                return Optional.ofNullable(clazz.cast(this.samplePromptsControlModeAsString()));
            }
            case "origins": {
                return Optional.ofNullable(clazz.cast(this.origins()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "identityProviderConfiguration": {
                return Optional.ofNullable(clazz.cast(this.identityProviderConfiguration()));
            }
            case "browserExtensionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.browserExtensionConfiguration()));
            }
            case "customizationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customizationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWebExperienceRequest, T> g) {
        return obj -> g.apply((CreateWebExperienceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String title;
        private String subtitle;
        private String welcomeMessage;
        private String samplePromptsControlMode;
        private List<String> origins = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private IdentityProviderConfiguration identityProviderConfiguration;
        private BrowserExtensionConfiguration browserExtensionConfiguration;
        private CustomizationConfiguration customizationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebExperienceRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.title(model.title);
            this.subtitle(model.subtitle);
            this.welcomeMessage(model.welcomeMessage);
            this.samplePromptsControlMode(model.samplePromptsControlMode);
            this.origins(model.origins);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
            this.identityProviderConfiguration(model.identityProviderConfiguration);
            this.browserExtensionConfiguration(model.browserExtensionConfiguration);
            this.customizationConfiguration(model.customizationConfiguration);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSubtitle() {
            return this.subtitle;
        }

        public final void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        @Override
        public final Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final String getWelcomeMessage() {
            return this.welcomeMessage;
        }

        public final void setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
        }

        @Override
        public final Builder welcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        public final String getSamplePromptsControlMode() {
            return this.samplePromptsControlMode;
        }

        public final void setSamplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
        }

        @Override
        public final Builder samplePromptsControlMode(String samplePromptsControlMode) {
            this.samplePromptsControlMode = samplePromptsControlMode;
            return this;
        }

        @Override
        public final Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode samplePromptsControlMode) {
            this.samplePromptsControlMode(samplePromptsControlMode == null ? null : samplePromptsControlMode.toString());
            return this;
        }

        public final Collection<String> getOrigins() {
            if (this.origins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.origins;
        }

        public final void setOrigins(Collection<String> origins) {
            this.origins = WebExperienceOriginsCopier.copy(origins);
        }

        @Override
        public final Builder origins(Collection<String> origins) {
            this.origins = WebExperienceOriginsCopier.copy(origins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder origins(String ... origins) {
            this.origins(Arrays.asList(origins));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final IdentityProviderConfiguration.Builder getIdentityProviderConfiguration() {
            return this.identityProviderConfiguration != null ? this.identityProviderConfiguration.toBuilder() : null;
        }

        public final void setIdentityProviderConfiguration(IdentityProviderConfiguration.BuilderImpl identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration != null ? identityProviderConfiguration.build() : null;
        }

        @Override
        public final Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        public final BrowserExtensionConfiguration.Builder getBrowserExtensionConfiguration() {
            return this.browserExtensionConfiguration != null ? this.browserExtensionConfiguration.toBuilder() : null;
        }

        public final void setBrowserExtensionConfiguration(BrowserExtensionConfiguration.BuilderImpl browserExtensionConfiguration) {
            this.browserExtensionConfiguration = browserExtensionConfiguration != null ? browserExtensionConfiguration.build() : null;
        }

        @Override
        public final Builder browserExtensionConfiguration(BrowserExtensionConfiguration browserExtensionConfiguration) {
            this.browserExtensionConfiguration = browserExtensionConfiguration;
            return this;
        }

        public final CustomizationConfiguration.Builder getCustomizationConfiguration() {
            return this.customizationConfiguration != null ? this.customizationConfiguration.toBuilder() : null;
        }

        public final void setCustomizationConfiguration(CustomizationConfiguration.BuilderImpl customizationConfiguration) {
            this.customizationConfiguration = customizationConfiguration != null ? customizationConfiguration.build() : null;
        }

        @Override
        public final Builder customizationConfiguration(CustomizationConfiguration customizationConfiguration) {
            this.customizationConfiguration = customizationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWebExperienceRequest build() {
            return new CreateWebExperienceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWebExperienceRequest> {
        public Builder applicationId(String var1);

        public Builder title(String var1);

        public Builder subtitle(String var1);

        public Builder welcomeMessage(String var1);

        public Builder samplePromptsControlMode(String var1);

        public Builder samplePromptsControlMode(WebExperienceSamplePromptsControlMode var1);

        public Builder origins(Collection<String> var1);

        public Builder origins(String ... var1);

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder identityProviderConfiguration(IdentityProviderConfiguration var1);

        default public Builder identityProviderConfiguration(Consumer<IdentityProviderConfiguration.Builder> identityProviderConfiguration) {
            return this.identityProviderConfiguration((IdentityProviderConfiguration)((IdentityProviderConfiguration.Builder)IdentityProviderConfiguration.builder().applyMutation(identityProviderConfiguration)).build());
        }

        public Builder browserExtensionConfiguration(BrowserExtensionConfiguration var1);

        default public Builder browserExtensionConfiguration(Consumer<BrowserExtensionConfiguration.Builder> browserExtensionConfiguration) {
            return this.browserExtensionConfiguration((BrowserExtensionConfiguration)((BrowserExtensionConfiguration.Builder)BrowserExtensionConfiguration.builder().applyMutation(browserExtensionConfiguration)).build());
        }

        public Builder customizationConfiguration(CustomizationConfiguration var1);

        default public Builder customizationConfiguration(Consumer<CustomizationConfiguration.Builder> customizationConfiguration) {
            return this.customizationConfiguration((CustomizationConfiguration)((CustomizationConfiguration.Builder)CustomizationConfiguration.builder().applyMutation(customizationConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

