/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.ActionConfiguration;
import software.amazon.awssdk.services.qbusiness.model.ActionConfigurationListCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.Tag;
import software.amazon.awssdk.services.qbusiness.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataAccessorRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, CreateDataAccessorRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(CreateDataAccessorRequest.getter(CreateDataAccessorRequest::applicationId)).setter(CreateDataAccessorRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principal").getter(CreateDataAccessorRequest.getter(CreateDataAccessorRequest::principal)).setter(CreateDataAccessorRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<List<ActionConfiguration>> ACTION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionConfigurations").getter(CreateDataAccessorRequest.getter(CreateDataAccessorRequest::actionConfigurations)).setter(CreateDataAccessorRequest.setter(Builder::actionConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDataAccessorRequest.getter(CreateDataAccessorRequest::clientToken)).setter(CreateDataAccessorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateDataAccessorRequest.getter(CreateDataAccessorRequest::displayName)).setter(CreateDataAccessorRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateDataAccessorRequest.getter(CreateDataAccessorRequest::tags)).setter(CreateDataAccessorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, PRINCIPAL_FIELD, ACTION_CONFIGURATIONS_FIELD, CLIENT_TOKEN_FIELD, DISPLAY_NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("principal", PRINCIPAL_FIELD);
            this.put("actionConfigurations", ACTION_CONFIGURATIONS_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String applicationId;
    private final String principal;
    private final List<ActionConfiguration> actionConfigurations;
    private final String clientToken;
    private final String displayName;
    private final List<Tag> tags;

    private CreateDataAccessorRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.principal = builder.principal;
        this.actionConfigurations = builder.actionConfigurations;
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.tags = builder.tags;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String principal() {
        return this.principal;
    }

    public final boolean hasActionConfigurations() {
        return this.actionConfigurations != null && !(this.actionConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ActionConfiguration> actionConfigurations() {
        return this.actionConfigurations;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionConfigurations() ? this.actionConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataAccessorRequest)) {
            return false;
        }
        CreateDataAccessorRequest other = (CreateDataAccessorRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.principal(), other.principal()) && this.hasActionConfigurations() == other.hasActionConfigurations() && Objects.equals(this.actionConfigurations(), other.actionConfigurations()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.displayName(), other.displayName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataAccessorRequest").add("ApplicationId", (Object)this.applicationId()).add("Principal", (Object)this.principal()).add("ActionConfigurations", this.hasActionConfigurations() ? this.actionConfigurations() : null).add("ClientToken", (Object)this.clientToken()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "actionConfigurations": {
                return Optional.ofNullable(clazz.cast(this.actionConfigurations()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataAccessorRequest, T> g) {
        return obj -> g.apply((CreateDataAccessorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String principal;
        private List<ActionConfiguration> actionConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String displayName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataAccessorRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.principal(model.principal);
            this.actionConfigurations(model.actionConfigurations);
            this.clientToken(model.clientToken);
            this.displayName(model.displayName);
            this.tags(model.tags);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final List<ActionConfiguration.Builder> getActionConfigurations() {
            List<ActionConfiguration.Builder> result = ActionConfigurationListCopier.copyToBuilder(this.actionConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionConfigurations(Collection<ActionConfiguration.BuilderImpl> actionConfigurations) {
            this.actionConfigurations = ActionConfigurationListCopier.copyFromBuilder(actionConfigurations);
        }

        @Override
        public final Builder actionConfigurations(Collection<ActionConfiguration> actionConfigurations) {
            this.actionConfigurations = ActionConfigurationListCopier.copy(actionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurations(ActionConfiguration ... actionConfigurations) {
            this.actionConfigurations(Arrays.asList(actionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurations(Consumer<ActionConfiguration.Builder> ... actionConfigurations) {
            this.actionConfigurations(Stream.of(actionConfigurations).map(c -> (ActionConfiguration)((ActionConfiguration.Builder)ActionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataAccessorRequest build() {
            return new CreateDataAccessorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataAccessorRequest> {
        public Builder applicationId(String var1);

        public Builder principal(String var1);

        public Builder actionConfigurations(Collection<ActionConfiguration> var1);

        public Builder actionConfigurations(ActionConfiguration ... var1);

        public Builder actionConfigurations(Consumer<ActionConfiguration.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder displayName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

