/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.PrincipalGroup;
import software.amazon.awssdk.services.qbusiness.model.PrincipalUser;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Principal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Principal> {
    private static final SdkField<PrincipalUser> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("user").getter(Principal.getter(Principal::user)).setter(Principal.setter(Builder::user)).constructor(PrincipalUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final SdkField<PrincipalGroup> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("group").getter(Principal.getter(Principal::group)).setter(Principal.setter(Builder::group)).constructor(PrincipalGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("user", USER_FIELD);
            this.put("group", GROUP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final PrincipalUser user;
    private final PrincipalGroup group;
    private final Type type;

    private Principal(BuilderImpl builder) {
        this.user = builder.user;
        this.group = builder.group;
        this.type = builder.type;
    }

    public final PrincipalUser user() {
        return this.user;
    }

    public final PrincipalGroup group() {
        return this.group;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Principal)) {
            return false;
        }
        Principal other = (Principal)obj;
        return Objects.equals(this.user(), other.user()) && Objects.equals(this.group(), other.group());
    }

    public final String toString() {
        return ToString.builder((String)"Principal").add("User", (Object)this.user()).add("Group", (Object)this.group()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
        }
        return Optional.empty();
    }

    public static Principal fromUser(PrincipalUser user) {
        return (Principal)Principal.builder().user(user).build();
    }

    public static Principal fromUser(Consumer<PrincipalUser.Builder> user) {
        PrincipalUser.Builder builder = PrincipalUser.builder();
        user.accept(builder);
        return Principal.fromUser((PrincipalUser)builder.build());
    }

    public static Principal fromGroup(PrincipalGroup group) {
        return (Principal)Principal.builder().group(group).build();
    }

    public static Principal fromGroup(Consumer<PrincipalGroup.Builder> group) {
        PrincipalGroup.Builder builder = PrincipalGroup.builder();
        group.accept(builder);
        return Principal.fromGroup((PrincipalGroup)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Principal, T> g) {
        return obj -> g.apply((Principal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        USER,
        GROUP,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private PrincipalUser user;
        private PrincipalGroup group;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Principal model) {
            this.user(model.user);
            this.group(model.group);
        }

        public final PrincipalUser.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(PrincipalUser.BuilderImpl user) {
            PrincipalUser oldValue = this.user;
            this.user = user != null ? user.build() : null;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
        }

        @Override
        public final Builder user(PrincipalUser user) {
            PrincipalUser oldValue = this.user;
            this.user = user;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
            return this;
        }

        public final PrincipalGroup.Builder getGroup() {
            return this.group != null ? this.group.toBuilder() : null;
        }

        public final void setGroup(PrincipalGroup.BuilderImpl group) {
            PrincipalGroup oldValue = this.group;
            this.group = group != null ? group.build() : null;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
        }

        @Override
        public final Builder group(PrincipalGroup group) {
            PrincipalGroup oldValue = this.group;
            this.group = group;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
            return this;
        }

        public Principal build() {
            return new Principal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Principal> {
        public Builder user(PrincipalUser var1);

        default public Builder user(Consumer<PrincipalUser.Builder> user) {
            return this.user((PrincipalUser)((PrincipalUser.Builder)PrincipalUser.builder().applyMutation(user)).build());
        }

        public Builder group(PrincipalGroup var1);

        default public Builder group(Consumer<PrincipalGroup.Builder> group) {
            return this.group((PrincipalGroup)((PrincipalGroup.Builder)PrincipalGroup.builder().applyMutation(group)).build());
        }
    }
}

