/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.AttachmentsConfiguration;
import software.amazon.awssdk.services.qbusiness.model.PersonalizationConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QAppsConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, UpdateApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::applicationId)).setter(UpdateApplicationRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityCenterInstanceArn").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::identityCenterInstanceArn)).setter(UpdateApplicationRequest.setter(Builder::identityCenterInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityCenterInstanceArn").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::displayName)).setter(UpdateApplicationRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::description)).setter(UpdateApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::roleArn)).setter(UpdateApplicationRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<AttachmentsConfiguration> ATTACHMENTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attachmentsConfiguration").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::attachmentsConfiguration)).setter(UpdateApplicationRequest.setter(Builder::attachmentsConfiguration)).constructor(AttachmentsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentsConfiguration").build()}).build();
    private static final SdkField<QAppsConfiguration> Q_APPS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("qAppsConfiguration").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::qAppsConfiguration)).setter(UpdateApplicationRequest.setter(Builder::qAppsConfiguration)).constructor(QAppsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qAppsConfiguration").build()}).build();
    private static final SdkField<PersonalizationConfiguration> PERSONALIZATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("personalizationConfiguration").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::personalizationConfiguration)).setter(UpdateApplicationRequest.setter(Builder::personalizationConfiguration)).constructor(PersonalizationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personalizationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, IDENTITY_CENTER_INSTANCE_ARN_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, ATTACHMENTS_CONFIGURATION_FIELD, Q_APPS_CONFIGURATION_FIELD, PERSONALIZATION_CONFIGURATION_FIELD));
    private final String applicationId;
    private final String identityCenterInstanceArn;
    private final String displayName;
    private final String description;
    private final String roleArn;
    private final AttachmentsConfiguration attachmentsConfiguration;
    private final QAppsConfiguration qAppsConfiguration;
    private final PersonalizationConfiguration personalizationConfiguration;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.identityCenterInstanceArn = builder.identityCenterInstanceArn;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.attachmentsConfiguration = builder.attachmentsConfiguration;
        this.qAppsConfiguration = builder.qAppsConfiguration;
        this.personalizationConfiguration = builder.personalizationConfiguration;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String identityCenterInstanceArn() {
        return this.identityCenterInstanceArn;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final AttachmentsConfiguration attachmentsConfiguration() {
        return this.attachmentsConfiguration;
    }

    public final QAppsConfiguration qAppsConfiguration() {
        return this.qAppsConfiguration;
    }

    public final PersonalizationConfiguration personalizationConfiguration() {
        return this.personalizationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.qAppsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalizationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.identityCenterInstanceArn(), other.identityCenterInstanceArn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.attachmentsConfiguration(), other.attachmentsConfiguration()) && Objects.equals(this.qAppsConfiguration(), other.qAppsConfiguration()) && Objects.equals(this.personalizationConfiguration(), other.personalizationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationRequest").add("ApplicationId", (Object)this.applicationId()).add("IdentityCenterInstanceArn", (Object)this.identityCenterInstanceArn()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("RoleArn", (Object)this.roleArn()).add("AttachmentsConfiguration", (Object)this.attachmentsConfiguration()).add("QAppsConfiguration", (Object)this.qAppsConfiguration()).add("PersonalizationConfiguration", (Object)this.personalizationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "identityCenterInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.identityCenterInstanceArn()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "attachmentsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.attachmentsConfiguration()));
            }
            case "qAppsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.qAppsConfiguration()));
            }
            case "personalizationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.personalizationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String identityCenterInstanceArn;
        private String displayName;
        private String description;
        private String roleArn;
        private AttachmentsConfiguration attachmentsConfiguration;
        private QAppsConfiguration qAppsConfiguration;
        private PersonalizationConfiguration personalizationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.identityCenterInstanceArn(model.identityCenterInstanceArn);
            this.displayName(model.displayName);
            this.description(model.description);
            this.roleArn(model.roleArn);
            this.attachmentsConfiguration(model.attachmentsConfiguration);
            this.qAppsConfiguration(model.qAppsConfiguration);
            this.personalizationConfiguration(model.personalizationConfiguration);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIdentityCenterInstanceArn() {
            return this.identityCenterInstanceArn;
        }

        public final void setIdentityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
        }

        @Override
        public final Builder identityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final AttachmentsConfiguration.Builder getAttachmentsConfiguration() {
            return this.attachmentsConfiguration != null ? this.attachmentsConfiguration.toBuilder() : null;
        }

        public final void setAttachmentsConfiguration(AttachmentsConfiguration.BuilderImpl attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration != null ? attachmentsConfiguration.build() : null;
        }

        @Override
        public final Builder attachmentsConfiguration(AttachmentsConfiguration attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration;
            return this;
        }

        public final QAppsConfiguration.Builder getQAppsConfiguration() {
            return this.qAppsConfiguration != null ? this.qAppsConfiguration.toBuilder() : null;
        }

        public final void setQAppsConfiguration(QAppsConfiguration.BuilderImpl qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration != null ? qAppsConfiguration.build() : null;
        }

        @Override
        public final Builder qAppsConfiguration(QAppsConfiguration qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration;
            return this;
        }

        public final PersonalizationConfiguration.Builder getPersonalizationConfiguration() {
            return this.personalizationConfiguration != null ? this.personalizationConfiguration.toBuilder() : null;
        }

        public final void setPersonalizationConfiguration(PersonalizationConfiguration.BuilderImpl personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration != null ? personalizationConfiguration.build() : null;
        }

        @Override
        public final Builder personalizationConfiguration(PersonalizationConfiguration personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationRequest> {
        public Builder applicationId(String var1);

        public Builder identityCenterInstanceArn(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder attachmentsConfiguration(AttachmentsConfiguration var1);

        default public Builder attachmentsConfiguration(Consumer<AttachmentsConfiguration.Builder> attachmentsConfiguration) {
            return this.attachmentsConfiguration((AttachmentsConfiguration)((AttachmentsConfiguration.Builder)AttachmentsConfiguration.builder().applyMutation(attachmentsConfiguration)).build());
        }

        public Builder qAppsConfiguration(QAppsConfiguration var1);

        default public Builder qAppsConfiguration(Consumer<QAppsConfiguration.Builder> qAppsConfiguration) {
            return this.qAppsConfiguration((QAppsConfiguration)((QAppsConfiguration.Builder)QAppsConfiguration.builder().applyMutation(qAppsConfiguration)).build());
        }

        public Builder personalizationConfiguration(PersonalizationConfiguration var1);

        default public Builder personalizationConfiguration(Consumer<PersonalizationConfiguration.Builder> personalizationConfiguration) {
            return this.personalizationConfiguration((PersonalizationConfiguration)((PersonalizationConfiguration.Builder)PersonalizationConfiguration.builder().applyMutation(personalizationConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

