/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeBoostingLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateAttributeBoostingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateAttributeBoostingConfiguration> {
    private static final SdkField<String> BOOSTING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("boostingLevel").getter(DateAttributeBoostingConfiguration.getter(DateAttributeBoostingConfiguration::boostingLevelAsString)).setter(DateAttributeBoostingConfiguration.setter(Builder::boostingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingLevel").build()}).build();
    private static final SdkField<Long> BOOSTING_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("boostingDurationInSeconds").getter(DateAttributeBoostingConfiguration.getter(DateAttributeBoostingConfiguration::boostingDurationInSeconds)).setter(DateAttributeBoostingConfiguration.setter(Builder::boostingDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingDurationInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOSTING_LEVEL_FIELD, BOOSTING_DURATION_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String boostingLevel;
    private final Long boostingDurationInSeconds;

    private DateAttributeBoostingConfiguration(BuilderImpl builder) {
        this.boostingLevel = builder.boostingLevel;
        this.boostingDurationInSeconds = builder.boostingDurationInSeconds;
    }

    public final DocumentAttributeBoostingLevel boostingLevel() {
        return DocumentAttributeBoostingLevel.fromValue(this.boostingLevel);
    }

    public final String boostingLevelAsString() {
        return this.boostingLevel;
    }

    public final Long boostingDurationInSeconds() {
        return this.boostingDurationInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boostingLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.boostingDurationInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateAttributeBoostingConfiguration)) {
            return false;
        }
        DateAttributeBoostingConfiguration other = (DateAttributeBoostingConfiguration)obj;
        return Objects.equals(this.boostingLevelAsString(), other.boostingLevelAsString()) && Objects.equals(this.boostingDurationInSeconds(), other.boostingDurationInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"DateAttributeBoostingConfiguration").add("BoostingLevel", (Object)this.boostingLevelAsString()).add("BoostingDurationInSeconds", (Object)this.boostingDurationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "boostingLevel": {
                return Optional.ofNullable(clazz.cast(this.boostingLevelAsString()));
            }
            case "boostingDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.boostingDurationInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateAttributeBoostingConfiguration, T> g) {
        return obj -> g.apply((DateAttributeBoostingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String boostingLevel;
        private Long boostingDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DateAttributeBoostingConfiguration model) {
            this.boostingLevel(model.boostingLevel);
            this.boostingDurationInSeconds(model.boostingDurationInSeconds);
        }

        public final String getBoostingLevel() {
            return this.boostingLevel;
        }

        public final void setBoostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
        }

        @Override
        public final Builder boostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
            return this;
        }

        @Override
        public final Builder boostingLevel(DocumentAttributeBoostingLevel boostingLevel) {
            this.boostingLevel(boostingLevel == null ? null : boostingLevel.toString());
            return this;
        }

        public final Long getBoostingDurationInSeconds() {
            return this.boostingDurationInSeconds;
        }

        public final void setBoostingDurationInSeconds(Long boostingDurationInSeconds) {
            this.boostingDurationInSeconds = boostingDurationInSeconds;
        }

        @Override
        public final Builder boostingDurationInSeconds(Long boostingDurationInSeconds) {
            this.boostingDurationInSeconds = boostingDurationInSeconds;
            return this;
        }

        public DateAttributeBoostingConfiguration build() {
            return new DateAttributeBoostingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateAttributeBoostingConfiguration> {
        public Builder boostingLevel(String var1);

        public Builder boostingLevel(DocumentAttributeBoostingLevel var1);

        public Builder boostingDurationInSeconds(Long var1);
    }
}

