/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.DataSourceSyncJob;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse;

public class ListDataSourceSyncJobsPublisher
implements SdkPublisher<ListDataSourceSyncJobsResponse> {
    private final QBusinessAsyncClient client;
    private final ListDataSourceSyncJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataSourceSyncJobsPublisher(QBusinessAsyncClient client, ListDataSourceSyncJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataSourceSyncJobsPublisher(QBusinessAsyncClient client, ListDataSourceSyncJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataSourceSyncJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataSourceSyncJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataSourceSyncJob> history() {
        Function<ListDataSourceSyncJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.history() != null) {
                return response.history().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataSourceSyncJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataSourceSyncJobsResponseFetcher
    implements AsyncPageFetcher<ListDataSourceSyncJobsResponse> {
        private ListDataSourceSyncJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSourceSyncJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataSourceSyncJobsResponse> nextPage(ListDataSourceSyncJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourceSyncJobsPublisher.this.client.listDataSourceSyncJobs(ListDataSourceSyncJobsPublisher.this.firstRequest);
            }
            return ListDataSourceSyncJobsPublisher.this.client.listDataSourceSyncJobs((ListDataSourceSyncJobsRequest)((Object)ListDataSourceSyncJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

