/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.ChatOutputStream;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseHandler;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TextOutputEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextOutputEvent>,
ChatOutputStream {
    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversationId").getter(TextOutputEvent.getter(TextOutputEvent::conversationId)).setter(TextOutputEvent.setter(Builder::conversationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()}).build();
    private static final SdkField<String> USER_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userMessageId").getter(TextOutputEvent.getter(TextOutputEvent::userMessageId)).setter(TextOutputEvent.setter(Builder::userMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userMessageId").build()}).build();
    private static final SdkField<String> SYSTEM_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemMessageId").getter(TextOutputEvent.getter(TextOutputEvent::systemMessageId)).setter(TextOutputEvent.setter(Builder::systemMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageId").build()}).build();
    private static final SdkField<String> SYSTEM_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemMessage").getter(TextOutputEvent.getter(TextOutputEvent::systemMessage)).setter(TextOutputEvent.setter(Builder::systemMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_ID_FIELD, USER_MESSAGE_ID_FIELD, SYSTEM_MESSAGE_ID_FIELD, SYSTEM_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String conversationId;
    private final String userMessageId;
    private final String systemMessageId;
    private final String systemMessage;

    protected TextOutputEvent(BuilderImpl builder) {
        this.conversationId = builder.conversationId;
        this.userMessageId = builder.userMessageId;
        this.systemMessageId = builder.systemMessageId;
        this.systemMessage = builder.systemMessage;
    }

    public final String conversationId() {
        return this.conversationId;
    }

    public final String userMessageId() {
        return this.userMessageId;
    }

    public final String systemMessageId() {
        return this.systemMessageId;
    }

    public final String systemMessage() {
        return this.systemMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextOutputEvent)) {
            return false;
        }
        TextOutputEvent other = (TextOutputEvent)obj;
        return Objects.equals(this.conversationId(), other.conversationId()) && Objects.equals(this.userMessageId(), other.userMessageId()) && Objects.equals(this.systemMessageId(), other.systemMessageId()) && Objects.equals(this.systemMessage(), other.systemMessage());
    }

    public final String toString() {
        return ToString.builder((String)"TextOutputEvent").add("ConversationId", (Object)this.conversationId()).add("UserMessageId", (Object)this.userMessageId()).add("SystemMessageId", (Object)this.systemMessageId()).add("SystemMessage", (Object)this.systemMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversationId": {
                return Optional.ofNullable(clazz.cast(this.conversationId()));
            }
            case "userMessageId": {
                return Optional.ofNullable(clazz.cast(this.userMessageId()));
            }
            case "systemMessageId": {
                return Optional.ofNullable(clazz.cast(this.systemMessageId()));
            }
            case "systemMessage": {
                return Optional.ofNullable(clazz.cast(this.systemMessage()));
            }
        }
        return Optional.empty();
    }

    public final TextOutputEvent copy(Consumer<? super Builder> modifier) {
        return (TextOutputEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextOutputEvent, T> g) {
        return obj -> g.apply((TextOutputEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(ChatResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private String conversationId;
        private String userMessageId;
        private String systemMessageId;
        private String systemMessage;

        protected BuilderImpl() {
        }

        protected BuilderImpl(TextOutputEvent model) {
            this.conversationId(model.conversationId);
            this.userMessageId(model.userMessageId);
            this.systemMessageId(model.systemMessageId);
            this.systemMessage(model.systemMessage);
        }

        public final String getConversationId() {
            return this.conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getUserMessageId() {
            return this.userMessageId;
        }

        public final void setUserMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
        }

        @Override
        public final Builder userMessageId(String userMessageId) {
            this.userMessageId = userMessageId;
            return this;
        }

        public final String getSystemMessageId() {
            return this.systemMessageId;
        }

        public final void setSystemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
        }

        @Override
        public final Builder systemMessageId(String systemMessageId) {
            this.systemMessageId = systemMessageId;
            return this;
        }

        public final String getSystemMessage() {
            return this.systemMessage;
        }

        public final void setSystemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
        }

        @Override
        public final Builder systemMessage(String systemMessage) {
            this.systemMessage = systemMessage;
            return this;
        }

        public TextOutputEvent build() {
            return new TextOutputEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextOutputEvent> {
        public Builder conversationId(String var1);

        public Builder userMessageId(String var1);

        public Builder systemMessageId(String var1);

        public Builder systemMessage(String var1);
    }
}

