/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.TopicConfiguration;

public class GetChatControlsConfigurationPublisher
implements SdkPublisher<GetChatControlsConfigurationResponse> {
    private final QBusinessAsyncClient client;
    private final GetChatControlsConfigurationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetChatControlsConfigurationPublisher(QBusinessAsyncClient client, GetChatControlsConfigurationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetChatControlsConfigurationPublisher(QBusinessAsyncClient client, GetChatControlsConfigurationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetChatControlsConfigurationResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetChatControlsConfigurationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TopicConfiguration> topicConfigurations() {
        Function<GetChatControlsConfigurationResponse, Iterator> getIterator = response -> {
            if (response != null && response.topicConfigurations() != null) {
                return response.topicConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetChatControlsConfigurationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetChatControlsConfigurationResponseFetcher
    implements AsyncPageFetcher<GetChatControlsConfigurationResponse> {
        private GetChatControlsConfigurationResponseFetcher() {
        }

        public boolean hasNextPage(GetChatControlsConfigurationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetChatControlsConfigurationResponse> nextPage(GetChatControlsConfigurationResponse previousPage) {
            if (previousPage == null) {
                return GetChatControlsConfigurationPublisher.this.client.getChatControlsConfiguration(GetChatControlsConfigurationPublisher.this.firstRequest);
            }
            return GetChatControlsConfigurationPublisher.this.client.getChatControlsConfiguration((GetChatControlsConfigurationRequest)((Object)GetChatControlsConfigurationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

