/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeBoostingLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateAttributeBoostingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateAttributeBoostingConfiguration> {
    private static final SdkField<Long> BOOSTING_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("boostingDurationInSeconds").getter(DateAttributeBoostingConfiguration.getter(DateAttributeBoostingConfiguration::boostingDurationInSeconds)).setter(DateAttributeBoostingConfiguration.setter(Builder::boostingDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingDurationInSeconds").build()}).build();
    private static final SdkField<String> BOOSTING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("boostingLevel").getter(DateAttributeBoostingConfiguration.getter(DateAttributeBoostingConfiguration::boostingLevelAsString)).setter(DateAttributeBoostingConfiguration.setter(Builder::boostingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boostingLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOSTING_DURATION_IN_SECONDS_FIELD, BOOSTING_LEVEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long boostingDurationInSeconds;
    private final String boostingLevel;

    private DateAttributeBoostingConfiguration(BuilderImpl builder) {
        this.boostingDurationInSeconds = builder.boostingDurationInSeconds;
        this.boostingLevel = builder.boostingLevel;
    }

    public final Long boostingDurationInSeconds() {
        return this.boostingDurationInSeconds;
    }

    public final DocumentAttributeBoostingLevel boostingLevel() {
        return DocumentAttributeBoostingLevel.fromValue(this.boostingLevel);
    }

    public final String boostingLevelAsString() {
        return this.boostingLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boostingDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.boostingLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateAttributeBoostingConfiguration)) {
            return false;
        }
        DateAttributeBoostingConfiguration other = (DateAttributeBoostingConfiguration)obj;
        return Objects.equals(this.boostingDurationInSeconds(), other.boostingDurationInSeconds()) && Objects.equals(this.boostingLevelAsString(), other.boostingLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DateAttributeBoostingConfiguration").add("BoostingDurationInSeconds", (Object)this.boostingDurationInSeconds()).add("BoostingLevel", (Object)this.boostingLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "boostingDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.boostingDurationInSeconds()));
            }
            case "boostingLevel": {
                return Optional.ofNullable(clazz.cast(this.boostingLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateAttributeBoostingConfiguration, T> g) {
        return obj -> g.apply((DateAttributeBoostingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long boostingDurationInSeconds;
        private String boostingLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(DateAttributeBoostingConfiguration model) {
            this.boostingDurationInSeconds(model.boostingDurationInSeconds);
            this.boostingLevel(model.boostingLevel);
        }

        public final Long getBoostingDurationInSeconds() {
            return this.boostingDurationInSeconds;
        }

        public final void setBoostingDurationInSeconds(Long boostingDurationInSeconds) {
            this.boostingDurationInSeconds = boostingDurationInSeconds;
        }

        @Override
        public final Builder boostingDurationInSeconds(Long boostingDurationInSeconds) {
            this.boostingDurationInSeconds = boostingDurationInSeconds;
            return this;
        }

        public final String getBoostingLevel() {
            return this.boostingLevel;
        }

        public final void setBoostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
        }

        @Override
        public final Builder boostingLevel(String boostingLevel) {
            this.boostingLevel = boostingLevel;
            return this;
        }

        @Override
        public final Builder boostingLevel(DocumentAttributeBoostingLevel boostingLevel) {
            this.boostingLevel(boostingLevel == null ? null : boostingLevel.toString());
            return this;
        }

        public DateAttributeBoostingConfiguration build() {
            return new DateAttributeBoostingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateAttributeBoostingConfiguration> {
        public Builder boostingDurationInSeconds(Long var1);

        public Builder boostingLevel(String var1);

        public Builder boostingLevel(DocumentAttributeBoostingLevel var1);
    }
}

