/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.MemberGroup;
import software.amazon.awssdk.services.qbusiness.model.MemberGroupsCopier;
import software.amazon.awssdk.services.qbusiness.model.MemberUser;
import software.amazon.awssdk.services.qbusiness.model.MemberUsersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupMembers
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupMembers> {
    private static final SdkField<List<MemberGroup>> MEMBER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memberGroups").getter(GroupMembers.getter(GroupMembers::memberGroups)).setter(GroupMembers.setter(Builder::memberGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MemberUser>> MEMBER_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memberUsers").getter(GroupMembers.getter(GroupMembers::memberUsers)).setter(GroupMembers.setter(Builder::memberUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberUsers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_GROUPS_FIELD, MEMBER_USERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<MemberGroup> memberGroups;
    private final List<MemberUser> memberUsers;

    private GroupMembers(BuilderImpl builder) {
        this.memberGroups = builder.memberGroups;
        this.memberUsers = builder.memberUsers;
    }

    public final boolean hasMemberGroups() {
        return this.memberGroups != null && !(this.memberGroups instanceof SdkAutoConstructList);
    }

    public final List<MemberGroup> memberGroups() {
        return this.memberGroups;
    }

    public final boolean hasMemberUsers() {
        return this.memberUsers != null && !(this.memberUsers instanceof SdkAutoConstructList);
    }

    public final List<MemberUser> memberUsers() {
        return this.memberUsers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberGroups() ? this.memberGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberUsers() ? this.memberUsers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupMembers)) {
            return false;
        }
        GroupMembers other = (GroupMembers)obj;
        return this.hasMemberGroups() == other.hasMemberGroups() && Objects.equals(this.memberGroups(), other.memberGroups()) && this.hasMemberUsers() == other.hasMemberUsers() && Objects.equals(this.memberUsers(), other.memberUsers());
    }

    public final String toString() {
        return ToString.builder((String)"GroupMembers").add("MemberGroups", this.hasMemberGroups() ? this.memberGroups() : null).add("MemberUsers", this.hasMemberUsers() ? this.memberUsers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memberGroups": {
                return Optional.ofNullable(clazz.cast(this.memberGroups()));
            }
            case "memberUsers": {
                return Optional.ofNullable(clazz.cast(this.memberUsers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupMembers, T> g) {
        return obj -> g.apply((GroupMembers)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MemberGroup> memberGroups = DefaultSdkAutoConstructList.getInstance();
        private List<MemberUser> memberUsers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupMembers model) {
            this.memberGroups(model.memberGroups);
            this.memberUsers(model.memberUsers);
        }

        public final List<MemberGroup.Builder> getMemberGroups() {
            List<MemberGroup.Builder> result = MemberGroupsCopier.copyToBuilder(this.memberGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberGroups(Collection<MemberGroup.BuilderImpl> memberGroups) {
            this.memberGroups = MemberGroupsCopier.copyFromBuilder(memberGroups);
        }

        @Override
        public final Builder memberGroups(Collection<MemberGroup> memberGroups) {
            this.memberGroups = MemberGroupsCopier.copy(memberGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberGroups(MemberGroup ... memberGroups) {
            this.memberGroups(Arrays.asList(memberGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberGroups(Consumer<MemberGroup.Builder> ... memberGroups) {
            this.memberGroups(Stream.of(memberGroups).map(c -> (MemberGroup)((MemberGroup.Builder)MemberGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MemberUser.Builder> getMemberUsers() {
            List<MemberUser.Builder> result = MemberUsersCopier.copyToBuilder(this.memberUsers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberUsers(Collection<MemberUser.BuilderImpl> memberUsers) {
            this.memberUsers = MemberUsersCopier.copyFromBuilder(memberUsers);
        }

        @Override
        public final Builder memberUsers(Collection<MemberUser> memberUsers) {
            this.memberUsers = MemberUsersCopier.copy(memberUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberUsers(MemberUser ... memberUsers) {
            this.memberUsers(Arrays.asList(memberUsers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberUsers(Consumer<MemberUser.Builder> ... memberUsers) {
            this.memberUsers(Stream.of(memberUsers).map(c -> (MemberUser)((MemberUser.Builder)MemberUser.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GroupMembers build() {
            return new GroupMembers(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupMembers> {
        public Builder memberGroups(Collection<MemberGroup> var1);

        public Builder memberGroups(MemberGroup ... var1);

        public Builder memberGroups(Consumer<MemberGroup.Builder> ... var1);

        public Builder memberUsers(Collection<MemberUser> var1);

        public Builder memberUsers(MemberUser ... var1);

        public Builder memberUsers(Consumer<MemberUser.Builder> ... var1);
    }
}

