/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuth2ClientCredentialConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuth2ClientCredentialConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(OAuth2ClientCredentialConfiguration.getter(OAuth2ClientCredentialConfiguration::roleArn)).setter(OAuth2ClientCredentialConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretArn").getter(OAuth2ClientCredentialConfiguration.getter(OAuth2ClientCredentialConfiguration::secretArn)).setter(OAuth2ClientCredentialConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, SECRET_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String secretArn;

    private OAuth2ClientCredentialConfiguration(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.secretArn = builder.secretArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2ClientCredentialConfiguration)) {
            return false;
        }
        OAuth2ClientCredentialConfiguration other = (OAuth2ClientCredentialConfiguration)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.secretArn(), other.secretArn());
    }

    public final String toString() {
        return ToString.builder((String)"OAuth2ClientCredentialConfiguration").add("RoleArn", (Object)this.roleArn()).add("SecretArn", (Object)this.secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "secretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OAuth2ClientCredentialConfiguration, T> g) {
        return obj -> g.apply((OAuth2ClientCredentialConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2ClientCredentialConfiguration model) {
            this.roleArn(model.roleArn);
            this.secretArn(model.secretArn);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public OAuth2ClientCredentialConfiguration build() {
            return new OAuth2ClientCredentialConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuth2ClientCredentialConfiguration> {
        public Builder roleArn(String var1);

        public Builder secretArn(String var1);
    }
}

