/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * The Amazon Q Apps feature capability within Amazon Q Business allows web experience users to create lightweight,
 * purpose-built AI apps to fulfill specific tasks from within their web experience. For example, users can create a Q
 * App that exclusively generates marketing-related content to improve your marketing team's productivity or a Q App for
 * writing customer emails and creating promotional content using a certain style of voice, tone, and branding. For more
 * information on the capabilities, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/deploy-experience-iam-role.html#q-apps-actions">Amazon
 * Q Apps capabilities</a> in the <i>Amazon Q Business User Guide</i>.
 * </p>
 * <p>
 * For an overview of the Amazon Q App APIs, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_Operations_QApps.html">Overview of Amazon Q Apps
 * API operations</a>.
 * </p>
 * <p>
 * For information about the IAM access control permissions you need to use the Amazon Q Apps API, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/deploy-experience-iam-role.html"> IAM role for the
 * Amazon Q Business web experience including Amazon Q Apps</a> in the <i>Amazon Q Business User Guide</i>.
 * </p>
 */
package software.amazon.awssdk.services.qapps;