/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response collected for a Amazon Q App session. This container represents a single response to a Q App session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QAppSessionData implements SdkPojo, Serializable, ToCopyableBuilder<QAppSessionData.Builder, QAppSessionData> {
    private static final SdkField<String> CARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cardId")
            .getter(getter(QAppSessionData::cardId)).setter(setter(Builder::cardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardId").build()).build();

    private static final SdkField<Document> VALUE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("value").getter(getter(QAppSessionData::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<User> USER_FIELD = SdkField.<User> builder(MarshallingType.SDK_POJO).memberName("user")
            .getter(getter(QAppSessionData::user)).setter(setter(Builder::user)).constructor(User::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final SdkField<String> SUBMISSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("submissionId").getter(getter(QAppSessionData::submissionId)).setter(setter(Builder::submissionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submissionId").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp")
            .getter(getter(QAppSessionData::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARD_ID_FIELD, VALUE_FIELD,
            USER_FIELD, SUBMISSION_ID_FIELD, TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cardId;

    private final Document value;

    private final User user;

    private final String submissionId;

    private final Instant timestamp;

    private QAppSessionData(BuilderImpl builder) {
        this.cardId = builder.cardId;
        this.value = builder.value;
        this.user = builder.user;
        this.submissionId = builder.submissionId;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The card Id associated with the response submitted for a Q App session.
     * </p>
     * 
     * @return The card Id associated with the response submitted for a Q App session.
     */
    public final String cardId() {
        return cardId;
    }

    /**
     * <p>
     * The response submitted for a Q App session.
     * </p>
     * 
     * @return The response submitted for a Q App session.
     */
    public final Document value() {
        return value;
    }

    /**
     * <p>
     * The user who submitted the response for a Q App session.
     * </p>
     * 
     * @return The user who submitted the response for a Q App session.
     */
    public final User user() {
        return user;
    }

    /**
     * <p>
     * The unique identifier of the submission.
     * </p>
     * 
     * @return The unique identifier of the submission.
     */
    public final String submissionId() {
        return submissionId;
    }

    /**
     * <p>
     * The date and time when the session data is submitted.
     * </p>
     * 
     * @return The date and time when the session data is submitted.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cardId());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(submissionId());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QAppSessionData)) {
            return false;
        }
        QAppSessionData other = (QAppSessionData) obj;
        return Objects.equals(cardId(), other.cardId()) && Objects.equals(value(), other.value())
                && Objects.equals(user(), other.user()) && Objects.equals(submissionId(), other.submissionId())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QAppSessionData").add("CardId", cardId()).add("Value", value()).add("User", user())
                .add("SubmissionId", submissionId()).add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cardId":
            return Optional.ofNullable(clazz.cast(cardId()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "user":
            return Optional.ofNullable(clazz.cast(user()));
        case "submissionId":
            return Optional.ofNullable(clazz.cast(submissionId()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cardId", CARD_ID_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("user", USER_FIELD);
        map.put("submissionId", SUBMISSION_ID_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QAppSessionData, T> g) {
        return obj -> g.apply((QAppSessionData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QAppSessionData> {
        /**
         * <p>
         * The card Id associated with the response submitted for a Q App session.
         * </p>
         * 
         * @param cardId
         *        The card Id associated with the response submitted for a Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardId(String cardId);

        /**
         * <p>
         * The response submitted for a Q App session.
         * </p>
         * 
         * @param value
         *        The response submitted for a Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Document value);

        /**
         * <p>
         * The user who submitted the response for a Q App session.
         * </p>
         * 
         * @param user
         *        The user who submitted the response for a Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(User user);

        /**
         * <p>
         * The user who submitted the response for a Q App session.
         * </p>
         * This is a convenience method that creates an instance of the {@link User.Builder} avoiding the need to create
         * one manually via {@link User#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link User.Builder#build()} is called immediately and its result is
         * passed to {@link #user(User)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link User.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(User)
         */
        default Builder user(Consumer<User.Builder> user) {
            return user(User.builder().applyMutation(user).build());
        }

        /**
         * <p>
         * The unique identifier of the submission.
         * </p>
         * 
         * @param submissionId
         *        The unique identifier of the submission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submissionId(String submissionId);

        /**
         * <p>
         * The date and time when the session data is submitted.
         * </p>
         * 
         * @param timestamp
         *        The date and time when the session data is submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String cardId;

        private Document value;

        private User user;

        private String submissionId;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(QAppSessionData model) {
            cardId(model.cardId);
            value(model.value);
            user(model.user);
            submissionId(model.submissionId);
            timestamp(model.timestamp);
        }

        public final String getCardId() {
            return cardId;
        }

        public final void setCardId(String cardId) {
            this.cardId = cardId;
        }

        @Override
        public final Builder cardId(String cardId) {
            this.cardId = cardId;
            return this;
        }

        public final Document getValue() {
            return value;
        }

        public final void setValue(Document value) {
            this.value = value;
        }

        @Override
        public final Builder value(Document value) {
            this.value = value;
            return this;
        }

        public final User.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(User.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public final Builder user(User user) {
            this.user = user;
            return this;
        }

        public final String getSubmissionId() {
            return submissionId;
        }

        public final void setSubmissionId(String submissionId) {
            this.submissionId = submissionId;
        }

        @Override
        public final Builder submissionId(String submissionId) {
            this.submissionId = submissionId;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public QAppSessionData build() {
            return new QAppSessionData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
