/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties defining an input card in an Amazon Q App.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CardInput implements SdkPojo, Serializable, ToCopyableBuilder<CardInput.Builder, CardInput> {
    private static final SdkField<TextInputCardInput> TEXT_INPUT_FIELD = SdkField
            .<TextInputCardInput> builder(MarshallingType.SDK_POJO).memberName("textInput").getter(getter(CardInput::textInput))
            .setter(setter(Builder::textInput)).constructor(TextInputCardInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textInput").build()).build();

    private static final SdkField<QQueryCardInput> Q_QUERY_FIELD = SdkField.<QQueryCardInput> builder(MarshallingType.SDK_POJO)
            .memberName("qQuery").getter(getter(CardInput::qQuery)).setter(setter(Builder::qQuery))
            .constructor(QQueryCardInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qQuery").build()).build();

    private static final SdkField<QPluginCardInput> Q_PLUGIN_FIELD = SdkField
            .<QPluginCardInput> builder(MarshallingType.SDK_POJO).memberName("qPlugin").getter(getter(CardInput::qPlugin))
            .setter(setter(Builder::qPlugin)).constructor(QPluginCardInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qPlugin").build()).build();

    private static final SdkField<FileUploadCardInput> FILE_UPLOAD_FIELD = SdkField
            .<FileUploadCardInput> builder(MarshallingType.SDK_POJO).memberName("fileUpload")
            .getter(getter(CardInput::fileUpload)).setter(setter(Builder::fileUpload)).constructor(FileUploadCardInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileUpload").build()).build();

    private static final SdkField<FormInputCardInput> FORM_INPUT_FIELD = SdkField
            .<FormInputCardInput> builder(MarshallingType.SDK_POJO).memberName("formInput").getter(getter(CardInput::formInput))
            .setter(setter(Builder::formInput)).constructor(FormInputCardInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_INPUT_FIELD,
            Q_QUERY_FIELD, Q_PLUGIN_FIELD, FILE_UPLOAD_FIELD, FORM_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TextInputCardInput textInput;

    private final QQueryCardInput qQuery;

    private final QPluginCardInput qPlugin;

    private final FileUploadCardInput fileUpload;

    private final FormInputCardInput formInput;

    private final Type type;

    private CardInput(BuilderImpl builder) {
        this.textInput = builder.textInput;
        this.qQuery = builder.qQuery;
        this.qPlugin = builder.qPlugin;
        this.fileUpload = builder.fileUpload;
        this.formInput = builder.formInput;
        this.type = builder.type;
    }

    /**
     * <p>
     * A container for the properties of the text input card.
     * </p>
     * 
     * @return A container for the properties of the text input card.
     */
    public final TextInputCardInput textInput() {
        return textInput;
    }

    /**
     * <p>
     * A container for the properties of the query input card.
     * </p>
     * 
     * @return A container for the properties of the query input card.
     */
    public final QQueryCardInput qQuery() {
        return qQuery;
    }

    /**
     * <p>
     * A container for the properties of the plugin input card.
     * </p>
     * 
     * @return A container for the properties of the plugin input card.
     */
    public final QPluginCardInput qPlugin() {
        return qPlugin;
    }

    /**
     * <p>
     * A container for the properties of the file upload input card.
     * </p>
     * 
     * @return A container for the properties of the file upload input card.
     */
    public final FileUploadCardInput fileUpload() {
        return fileUpload;
    }

    /**
     * <p>
     * A container for the properties of the form input card.
     * </p>
     * 
     * @return A container for the properties of the form input card.
     */
    public final FormInputCardInput formInput() {
        return formInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textInput());
        hashCode = 31 * hashCode + Objects.hashCode(qQuery());
        hashCode = 31 * hashCode + Objects.hashCode(qPlugin());
        hashCode = 31 * hashCode + Objects.hashCode(fileUpload());
        hashCode = 31 * hashCode + Objects.hashCode(formInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CardInput)) {
            return false;
        }
        CardInput other = (CardInput) obj;
        return Objects.equals(textInput(), other.textInput()) && Objects.equals(qQuery(), other.qQuery())
                && Objects.equals(qPlugin(), other.qPlugin()) && Objects.equals(fileUpload(), other.fileUpload())
                && Objects.equals(formInput(), other.formInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CardInput").add("TextInput", textInput()).add("QQuery", qQuery()).add("QPlugin", qPlugin())
                .add("FileUpload", fileUpload()).add("FormInput", formInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textInput":
            return Optional.ofNullable(clazz.cast(textInput()));
        case "qQuery":
            return Optional.ofNullable(clazz.cast(qQuery()));
        case "qPlugin":
            return Optional.ofNullable(clazz.cast(qPlugin()));
        case "fileUpload":
            return Optional.ofNullable(clazz.cast(fileUpload()));
        case "formInput":
            return Optional.ofNullable(clazz.cast(formInput()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #textInput()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the text input card.
     * </p>
     * 
     * @param textInput
     *        A container for the properties of the text input card.
     */
    public static CardInput fromTextInput(TextInputCardInput textInput) {
        return builder().textInput(textInput).build();
    }

    /**
     * Create an instance of this class with {@link #textInput()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the text input card.
     * </p>
     * 
     * @param textInput
     *        A container for the properties of the text input card.
     */
    public static CardInput fromTextInput(Consumer<TextInputCardInput.Builder> textInput) {
        TextInputCardInput.Builder builder = TextInputCardInput.builder();
        textInput.accept(builder);
        return fromTextInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #qQuery()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the query input card.
     * </p>
     * 
     * @param qQuery
     *        A container for the properties of the query input card.
     */
    public static CardInput fromQQuery(QQueryCardInput qQuery) {
        return builder().qQuery(qQuery).build();
    }

    /**
     * Create an instance of this class with {@link #qQuery()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the query input card.
     * </p>
     * 
     * @param qQuery
     *        A container for the properties of the query input card.
     */
    public static CardInput fromQQuery(Consumer<QQueryCardInput.Builder> qQuery) {
        QQueryCardInput.Builder builder = QQueryCardInput.builder();
        qQuery.accept(builder);
        return fromQQuery(builder.build());
    }

    /**
     * Create an instance of this class with {@link #qPlugin()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the plugin input card.
     * </p>
     * 
     * @param qPlugin
     *        A container for the properties of the plugin input card.
     */
    public static CardInput fromQPlugin(QPluginCardInput qPlugin) {
        return builder().qPlugin(qPlugin).build();
    }

    /**
     * Create an instance of this class with {@link #qPlugin()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the plugin input card.
     * </p>
     * 
     * @param qPlugin
     *        A container for the properties of the plugin input card.
     */
    public static CardInput fromQPlugin(Consumer<QPluginCardInput.Builder> qPlugin) {
        QPluginCardInput.Builder builder = QPluginCardInput.builder();
        qPlugin.accept(builder);
        return fromQPlugin(builder.build());
    }

    /**
     * Create an instance of this class with {@link #fileUpload()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the file upload input card.
     * </p>
     * 
     * @param fileUpload
     *        A container for the properties of the file upload input card.
     */
    public static CardInput fromFileUpload(FileUploadCardInput fileUpload) {
        return builder().fileUpload(fileUpload).build();
    }

    /**
     * Create an instance of this class with {@link #fileUpload()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the file upload input card.
     * </p>
     * 
     * @param fileUpload
     *        A container for the properties of the file upload input card.
     */
    public static CardInput fromFileUpload(Consumer<FileUploadCardInput.Builder> fileUpload) {
        FileUploadCardInput.Builder builder = FileUploadCardInput.builder();
        fileUpload.accept(builder);
        return fromFileUpload(builder.build());
    }

    /**
     * Create an instance of this class with {@link #formInput()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the form input card.
     * </p>
     * 
     * @param formInput
     *        A container for the properties of the form input card.
     */
    public static CardInput fromFormInput(FormInputCardInput formInput) {
        return builder().formInput(formInput).build();
    }

    /**
     * Create an instance of this class with {@link #formInput()} initialized to the given value.
     *
     * <p>
     * A container for the properties of the form input card.
     * </p>
     * 
     * @param formInput
     *        A container for the properties of the form input card.
     */
    public static CardInput fromFormInput(Consumer<FormInputCardInput.Builder> formInput) {
        FormInputCardInput.Builder builder = FormInputCardInput.builder();
        formInput.accept(builder);
        return fromFormInput(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("textInput", TEXT_INPUT_FIELD);
        map.put("qQuery", Q_QUERY_FIELD);
        map.put("qPlugin", Q_PLUGIN_FIELD);
        map.put("fileUpload", FILE_UPLOAD_FIELD);
        map.put("formInput", FORM_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CardInput, T> g) {
        return obj -> g.apply((CardInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CardInput> {
        /**
         * <p>
         * A container for the properties of the text input card.
         * </p>
         * 
         * @param textInput
         *        A container for the properties of the text input card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textInput(TextInputCardInput textInput);

        /**
         * <p>
         * A container for the properties of the text input card.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextInputCardInput.Builder} avoiding the
         * need to create one manually via {@link TextInputCardInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextInputCardInput.Builder#build()} is called immediately and its
         * result is passed to {@link #textInput(TextInputCardInput)}.
         * 
         * @param textInput
         *        a consumer that will call methods on {@link TextInputCardInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textInput(TextInputCardInput)
         */
        default Builder textInput(Consumer<TextInputCardInput.Builder> textInput) {
            return textInput(TextInputCardInput.builder().applyMutation(textInput).build());
        }

        /**
         * <p>
         * A container for the properties of the query input card.
         * </p>
         * 
         * @param qQuery
         *        A container for the properties of the query input card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qQuery(QQueryCardInput qQuery);

        /**
         * <p>
         * A container for the properties of the query input card.
         * </p>
         * This is a convenience method that creates an instance of the {@link QQueryCardInput.Builder} avoiding the
         * need to create one manually via {@link QQueryCardInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QQueryCardInput.Builder#build()} is called immediately and its
         * result is passed to {@link #qQuery(QQueryCardInput)}.
         * 
         * @param qQuery
         *        a consumer that will call methods on {@link QQueryCardInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qQuery(QQueryCardInput)
         */
        default Builder qQuery(Consumer<QQueryCardInput.Builder> qQuery) {
            return qQuery(QQueryCardInput.builder().applyMutation(qQuery).build());
        }

        /**
         * <p>
         * A container for the properties of the plugin input card.
         * </p>
         * 
         * @param qPlugin
         *        A container for the properties of the plugin input card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qPlugin(QPluginCardInput qPlugin);

        /**
         * <p>
         * A container for the properties of the plugin input card.
         * </p>
         * This is a convenience method that creates an instance of the {@link QPluginCardInput.Builder} avoiding the
         * need to create one manually via {@link QPluginCardInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QPluginCardInput.Builder#build()} is called immediately and its
         * result is passed to {@link #qPlugin(QPluginCardInput)}.
         * 
         * @param qPlugin
         *        a consumer that will call methods on {@link QPluginCardInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qPlugin(QPluginCardInput)
         */
        default Builder qPlugin(Consumer<QPluginCardInput.Builder> qPlugin) {
            return qPlugin(QPluginCardInput.builder().applyMutation(qPlugin).build());
        }

        /**
         * <p>
         * A container for the properties of the file upload input card.
         * </p>
         * 
         * @param fileUpload
         *        A container for the properties of the file upload input card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileUpload(FileUploadCardInput fileUpload);

        /**
         * <p>
         * A container for the properties of the file upload input card.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileUploadCardInput.Builder} avoiding the
         * need to create one manually via {@link FileUploadCardInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileUploadCardInput.Builder#build()} is called immediately and
         * its result is passed to {@link #fileUpload(FileUploadCardInput)}.
         * 
         * @param fileUpload
         *        a consumer that will call methods on {@link FileUploadCardInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileUpload(FileUploadCardInput)
         */
        default Builder fileUpload(Consumer<FileUploadCardInput.Builder> fileUpload) {
            return fileUpload(FileUploadCardInput.builder().applyMutation(fileUpload).build());
        }

        /**
         * <p>
         * A container for the properties of the form input card.
         * </p>
         * 
         * @param formInput
         *        A container for the properties of the form input card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formInput(FormInputCardInput formInput);

        /**
         * <p>
         * A container for the properties of the form input card.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormInputCardInput.Builder} avoiding the
         * need to create one manually via {@link FormInputCardInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormInputCardInput.Builder#build()} is called immediately and its
         * result is passed to {@link #formInput(FormInputCardInput)}.
         * 
         * @param formInput
         *        a consumer that will call methods on {@link FormInputCardInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formInput(FormInputCardInput)
         */
        default Builder formInput(Consumer<FormInputCardInput.Builder> formInput) {
            return formInput(FormInputCardInput.builder().applyMutation(formInput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextInputCardInput textInput;

        private QQueryCardInput qQuery;

        private QPluginCardInput qPlugin;

        private FileUploadCardInput fileUpload;

        private FormInputCardInput formInput;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CardInput model) {
            textInput(model.textInput);
            qQuery(model.qQuery);
            qPlugin(model.qPlugin);
            fileUpload(model.fileUpload);
            formInput(model.formInput);
        }

        public final TextInputCardInput.Builder getTextInput() {
            return textInput != null ? textInput.toBuilder() : null;
        }

        public final void setTextInput(TextInputCardInput.BuilderImpl textInput) {
            Object oldValue = this.textInput;
            this.textInput = textInput != null ? textInput.build() : null;
            handleUnionValueChange(Type.TEXT_INPUT, oldValue, this.textInput);
        }

        @Override
        public final Builder textInput(TextInputCardInput textInput) {
            Object oldValue = this.textInput;
            this.textInput = textInput;
            handleUnionValueChange(Type.TEXT_INPUT, oldValue, this.textInput);
            return this;
        }

        public final QQueryCardInput.Builder getQQuery() {
            return qQuery != null ? qQuery.toBuilder() : null;
        }

        public final void setQQuery(QQueryCardInput.BuilderImpl qQuery) {
            Object oldValue = this.qQuery;
            this.qQuery = qQuery != null ? qQuery.build() : null;
            handleUnionValueChange(Type.Q_QUERY, oldValue, this.qQuery);
        }

        @Override
        public final Builder qQuery(QQueryCardInput qQuery) {
            Object oldValue = this.qQuery;
            this.qQuery = qQuery;
            handleUnionValueChange(Type.Q_QUERY, oldValue, this.qQuery);
            return this;
        }

        public final QPluginCardInput.Builder getQPlugin() {
            return qPlugin != null ? qPlugin.toBuilder() : null;
        }

        public final void setQPlugin(QPluginCardInput.BuilderImpl qPlugin) {
            Object oldValue = this.qPlugin;
            this.qPlugin = qPlugin != null ? qPlugin.build() : null;
            handleUnionValueChange(Type.Q_PLUGIN, oldValue, this.qPlugin);
        }

        @Override
        public final Builder qPlugin(QPluginCardInput qPlugin) {
            Object oldValue = this.qPlugin;
            this.qPlugin = qPlugin;
            handleUnionValueChange(Type.Q_PLUGIN, oldValue, this.qPlugin);
            return this;
        }

        public final FileUploadCardInput.Builder getFileUpload() {
            return fileUpload != null ? fileUpload.toBuilder() : null;
        }

        public final void setFileUpload(FileUploadCardInput.BuilderImpl fileUpload) {
            Object oldValue = this.fileUpload;
            this.fileUpload = fileUpload != null ? fileUpload.build() : null;
            handleUnionValueChange(Type.FILE_UPLOAD, oldValue, this.fileUpload);
        }

        @Override
        public final Builder fileUpload(FileUploadCardInput fileUpload) {
            Object oldValue = this.fileUpload;
            this.fileUpload = fileUpload;
            handleUnionValueChange(Type.FILE_UPLOAD, oldValue, this.fileUpload);
            return this;
        }

        public final FormInputCardInput.Builder getFormInput() {
            return formInput != null ? formInput.toBuilder() : null;
        }

        public final void setFormInput(FormInputCardInput.BuilderImpl formInput) {
            Object oldValue = this.formInput;
            this.formInput = formInput != null ? formInput.build() : null;
            handleUnionValueChange(Type.FORM_INPUT, oldValue, this.formInput);
        }

        @Override
        public final Builder formInput(FormInputCardInput formInput) {
            Object oldValue = this.formInput;
            this.formInput = formInput;
            handleUnionValueChange(Type.FORM_INPUT, oldValue, this.formInput);
            return this;
        }

        @Override
        public CardInput build() {
            return new CardInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CardInput#type()
     */
    public enum Type {
        TEXT_INPUT,

        Q_QUERY,

        Q_PLUGIN,

        FILE_UPLOAD,

        FORM_INPUT,

        UNKNOWN_TO_SDK_VERSION
    }
}
