/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.LibraryItemListCopier;
import software.amazon.awssdk.services.qapps.model.LibraryItemMember;
import software.amazon.awssdk.services.qapps.model.QAppsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLibraryItemsResponse
extends QAppsResponse
implements ToCopyableBuilder<Builder, ListLibraryItemsResponse> {
    private static final SdkField<List<LibraryItemMember>> LIBRARY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("libraryItems").getter(ListLibraryItemsResponse.getter(ListLibraryItemsResponse::libraryItems)).setter(ListLibraryItemsResponse.setter(Builder::libraryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LibraryItemMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLibraryItemsResponse.getter(ListLibraryItemsResponse::nextToken)).setter(ListLibraryItemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIBRARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLibraryItemsResponse.memberNameToFieldInitializer();
    private final List<LibraryItemMember> libraryItems;
    private final String nextToken;

    private ListLibraryItemsResponse(BuilderImpl builder) {
        super(builder);
        this.libraryItems = builder.libraryItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLibraryItems() {
        return this.libraryItems != null && !(this.libraryItems instanceof SdkAutoConstructList);
    }

    public final List<LibraryItemMember> libraryItems() {
        return this.libraryItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLibraryItems() ? this.libraryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLibraryItemsResponse)) {
            return false;
        }
        ListLibraryItemsResponse other = (ListLibraryItemsResponse)((Object)obj);
        return this.hasLibraryItems() == other.hasLibraryItems() && Objects.equals(this.libraryItems(), other.libraryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLibraryItemsResponse").add("LibraryItems", this.hasLibraryItems() ? this.libraryItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "libraryItems": {
                return Optional.ofNullable(clazz.cast(this.libraryItems()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("libraryItems", LIBRARY_ITEMS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLibraryItemsResponse, T> g) {
        return obj -> g.apply((ListLibraryItemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsResponse.BuilderImpl
    implements Builder {
        private List<LibraryItemMember> libraryItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLibraryItemsResponse model) {
            super(model);
            this.libraryItems(model.libraryItems);
            this.nextToken(model.nextToken);
        }

        public final List<LibraryItemMember.Builder> getLibraryItems() {
            List<LibraryItemMember.Builder> result = LibraryItemListCopier.copyToBuilder(this.libraryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLibraryItems(Collection<LibraryItemMember.BuilderImpl> libraryItems) {
            this.libraryItems = LibraryItemListCopier.copyFromBuilder(libraryItems);
        }

        @Override
        public final Builder libraryItems(Collection<LibraryItemMember> libraryItems) {
            this.libraryItems = LibraryItemListCopier.copy(libraryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder libraryItems(LibraryItemMember ... libraryItems) {
            this.libraryItems(Arrays.asList(libraryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder libraryItems(Consumer<LibraryItemMember.Builder> ... libraryItems) {
            this.libraryItems(Stream.of(libraryItems).map(c -> (LibraryItemMember)((LibraryItemMember.Builder)LibraryItemMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLibraryItemsResponse build() {
            return new ListLibraryItemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QAppsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLibraryItemsResponse> {
        public Builder libraryItems(Collection<LibraryItemMember> var1);

        public Builder libraryItems(LibraryItemMember ... var1);

        public Builder libraryItems(Consumer<LibraryItemMember.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

