/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.QAppsRequest;
import software.amazon.awssdk.services.qapps.model.SessionSharingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQAppSessionMetadataRequest
extends QAppsRequest
implements ToCopyableBuilder<Builder, UpdateQAppSessionMetadataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(UpdateQAppSessionMetadataRequest.getter(UpdateQAppSessionMetadataRequest::instanceId)).setter(UpdateQAppSessionMetadataRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(UpdateQAppSessionMetadataRequest.getter(UpdateQAppSessionMetadataRequest::sessionId)).setter(UpdateQAppSessionMetadataRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionName").getter(UpdateQAppSessionMetadataRequest.getter(UpdateQAppSessionMetadataRequest::sessionName)).setter(UpdateQAppSessionMetadataRequest.setter(Builder::sessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionName").build()}).build();
    private static final SdkField<SessionSharingConfiguration> SHARING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sharingConfiguration").getter(UpdateQAppSessionMetadataRequest.getter(UpdateQAppSessionMetadataRequest::sharingConfiguration)).setter(UpdateQAppSessionMetadataRequest.setter(Builder::sharingConfiguration)).constructor(SessionSharingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, SESSION_ID_FIELD, SESSION_NAME_FIELD, SHARING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateQAppSessionMetadataRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String sessionId;
    private final String sessionName;
    private final SessionSharingConfiguration sharingConfiguration;

    private UpdateQAppSessionMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.sessionId = builder.sessionId;
        this.sessionName = builder.sessionName;
        this.sharingConfiguration = builder.sharingConfiguration;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String sessionName() {
        return this.sessionName;
    }

    public final SessionSharingConfiguration sharingConfiguration() {
        return this.sharingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQAppSessionMetadataRequest)) {
            return false;
        }
        UpdateQAppSessionMetadataRequest other = (UpdateQAppSessionMetadataRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionName(), other.sessionName()) && Objects.equals(this.sharingConfiguration(), other.sharingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQAppSessionMetadataRequest").add("InstanceId", (Object)this.instanceId()).add("SessionId", (Object)this.sessionId()).add("SessionName", (Object)this.sessionName()).add("SharingConfiguration", (Object)this.sharingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "sessionName": {
                return Optional.ofNullable(clazz.cast(this.sessionName()));
            }
            case "sharingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sharingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instance-id", INSTANCE_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionName", SESSION_NAME_FIELD);
        map.put("sharingConfiguration", SHARING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQAppSessionMetadataRequest, T> g) {
        return obj -> g.apply((UpdateQAppSessionMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String sessionId;
        private String sessionName;
        private SessionSharingConfiguration sharingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQAppSessionMetadataRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.sessionId(model.sessionId);
            this.sessionName(model.sessionName);
            this.sharingConfiguration(model.sharingConfiguration);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionName() {
            return this.sessionName;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        @Override
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final SessionSharingConfiguration.Builder getSharingConfiguration() {
            return this.sharingConfiguration != null ? this.sharingConfiguration.toBuilder() : null;
        }

        public final void setSharingConfiguration(SessionSharingConfiguration.BuilderImpl sharingConfiguration) {
            this.sharingConfiguration = sharingConfiguration != null ? sharingConfiguration.build() : null;
        }

        @Override
        public final Builder sharingConfiguration(SessionSharingConfiguration sharingConfiguration) {
            this.sharingConfiguration = sharingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQAppSessionMetadataRequest build() {
            return new UpdateQAppSessionMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QAppsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQAppSessionMetadataRequest> {
        public Builder instanceId(String var1);

        public Builder sessionId(String var1);

        public Builder sessionName(String var1);

        public Builder sharingConfiguration(SessionSharingConfiguration var1);

        default public Builder sharingConfiguration(Consumer<SessionSharingConfiguration.Builder> sharingConfiguration) {
            return this.sharingConfiguration((SessionSharingConfiguration)((SessionSharingConfiguration.Builder)SessionSharingConfiguration.builder().applyMutation(sharingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

