/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.PrincipalOutputUserTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrincipalOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrincipalOutput> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(PrincipalOutput.getter(PrincipalOutput::userId)).setter(PrincipalOutput.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> USER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userType").getter(PrincipalOutput.getter(PrincipalOutput::userTypeAsString)).setter(PrincipalOutput.setter(Builder::userType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userType").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("email").getter(PrincipalOutput.getter(PrincipalOutput::email)).setter(PrincipalOutput.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, USER_TYPE_FIELD, EMAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrincipalOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userId;
    private final String userType;
    private final String email;

    private PrincipalOutput(BuilderImpl builder) {
        this.userId = builder.userId;
        this.userType = builder.userType;
        this.email = builder.email;
    }

    public final String userId() {
        return this.userId;
    }

    public final PrincipalOutputUserTypeEnum userType() {
        return PrincipalOutputUserTypeEnum.fromValue(this.userType);
    }

    public final String userTypeAsString() {
        return this.userType;
    }

    public final String email() {
        return this.email;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalOutput)) {
            return false;
        }
        PrincipalOutput other = (PrincipalOutput)obj;
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.userTypeAsString(), other.userTypeAsString()) && Objects.equals(this.email(), other.email());
    }

    public final String toString() {
        return ToString.builder((String)"PrincipalOutput").add("UserId", (Object)this.userId()).add("UserType", (Object)this.userTypeAsString()).add("Email", (Object)this.email()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "userType": {
                return Optional.ofNullable(clazz.cast(this.userTypeAsString()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("userId", USER_ID_FIELD);
        map.put("userType", USER_TYPE_FIELD);
        map.put("email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrincipalOutput, T> g) {
        return obj -> g.apply((PrincipalOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userId;
        private String userType;
        private String email;

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalOutput model) {
            this.userId(model.userId);
            this.userType(model.userType);
            this.email(model.email);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserType() {
            return this.userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        public final Builder userType(PrincipalOutputUserTypeEnum userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public PrincipalOutput build() {
            return new PrincipalOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrincipalOutput> {
        public Builder userId(String var1);

        public Builder userType(String var1);

        public Builder userType(PrincipalOutputUserTypeEnum var1);

        public Builder email(String var1);
    }
}

