/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.AttributeFilter;
import software.amazon.awssdk.services.qapps.model.CardOutputSource;
import software.amazon.awssdk.services.qapps.model.CardType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QQueryCardInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QQueryCardInput> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(QQueryCardInput.getter(QQueryCardInput::title)).setter(QQueryCardInput.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(QQueryCardInput.getter(QQueryCardInput::id)).setter(QQueryCardInput.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(QQueryCardInput.getter(QQueryCardInput::typeAsString)).setter(QQueryCardInput.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prompt").getter(QQueryCardInput.getter(QQueryCardInput::prompt)).setter(QQueryCardInput.setter(Builder::prompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prompt").build()}).build();
    private static final SdkField<String> OUTPUT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputSource").getter(QQueryCardInput.getter(QQueryCardInput::outputSourceAsString)).setter(QQueryCardInput.setter(Builder::outputSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSource").build()}).build();
    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attributeFilter").getter(QQueryCardInput.getter(QQueryCardInput::attributeFilter)).setter(QQueryCardInput.setter(Builder::attributeFilter)).constructor(AttributeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ID_FIELD, TYPE_FIELD, PROMPT_FIELD, OUTPUT_SOURCE_FIELD, ATTRIBUTE_FILTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String id;
    private final String type;
    private final String prompt;
    private final String outputSource;
    private final AttributeFilter attributeFilter;

    private QQueryCardInput(BuilderImpl builder) {
        this.title = builder.title;
        this.id = builder.id;
        this.type = builder.type;
        this.prompt = builder.prompt;
        this.outputSource = builder.outputSource;
        this.attributeFilter = builder.attributeFilter;
    }

    public final String title() {
        return this.title;
    }

    public final String id() {
        return this.id;
    }

    public final CardType type() {
        return CardType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String prompt() {
        return this.prompt;
    }

    public final CardOutputSource outputSource() {
        return CardOutputSource.fromValue(this.outputSource);
    }

    public final String outputSourceAsString() {
        return this.outputSource;
    }

    public final AttributeFilter attributeFilter() {
        return this.attributeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QQueryCardInput)) {
            return false;
        }
        QQueryCardInput other = (QQueryCardInput)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.prompt(), other.prompt()) && Objects.equals(this.outputSourceAsString(), other.outputSourceAsString()) && Objects.equals(this.attributeFilter(), other.attributeFilter());
    }

    public final String toString() {
        return ToString.builder((String)"QQueryCardInput").add("Title", (Object)this.title()).add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Prompt", (Object)this.prompt()).add("OutputSource", (Object)this.outputSourceAsString()).add("AttributeFilter", (Object)this.attributeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "prompt": {
                return Optional.ofNullable(clazz.cast(this.prompt()));
            }
            case "outputSource": {
                return Optional.ofNullable(clazz.cast(this.outputSourceAsString()));
            }
            case "attributeFilter": {
                return Optional.ofNullable(clazz.cast(this.attributeFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QQueryCardInput, T> g) {
        return obj -> g.apply((QQueryCardInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String id;
        private String type;
        private String prompt;
        private String outputSource;
        private AttributeFilter attributeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(QQueryCardInput model) {
            this.title(model.title);
            this.id(model.id);
            this.type(model.type);
            this.prompt(model.prompt);
            this.outputSource(model.outputSource);
            this.attributeFilter(model.attributeFilter);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPrompt() {
            return this.prompt;
        }

        public final void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public final Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public final String getOutputSource() {
            return this.outputSource;
        }

        public final void setOutputSource(String outputSource) {
            this.outputSource = outputSource;
        }

        @Override
        public final Builder outputSource(String outputSource) {
            this.outputSource = outputSource;
            return this;
        }

        @Override
        public final Builder outputSource(CardOutputSource outputSource) {
            this.outputSource(outputSource == null ? null : outputSource.toString());
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return this.attributeFilter != null ? this.attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public QQueryCardInput build() {
            return new QQueryCardInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QQueryCardInput> {
        public Builder title(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(CardType var1);

        public Builder prompt(String var1);

        public Builder outputSource(String var1);

        public Builder outputSource(CardOutputSource var1);

        public Builder attributeFilter(AttributeFilter var1);

        default public Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return this.attributeFilter((AttributeFilter)((AttributeFilter.Builder)AttributeFilter.builder().applyMutation(attributeFilter)).build());
        }
    }
}

