/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.CardType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QPluginCardInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QPluginCardInput> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(QPluginCardInput.getter(QPluginCardInput::title)).setter(QPluginCardInput.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(QPluginCardInput.getter(QPluginCardInput::id)).setter(QPluginCardInput.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(QPluginCardInput.getter(QPluginCardInput::typeAsString)).setter(QPluginCardInput.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prompt").getter(QPluginCardInput.getter(QPluginCardInput::prompt)).setter(QPluginCardInput.setter(Builder::prompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prompt").build()}).build();
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginId").getter(QPluginCardInput.getter(QPluginCardInput::pluginId)).setter(QPluginCardInput.setter(Builder::pluginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()}).build();
    private static final SdkField<String> ACTION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionIdentifier").getter(QPluginCardInput.getter(QPluginCardInput::actionIdentifier)).setter(QPluginCardInput.setter(Builder::actionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ID_FIELD, TYPE_FIELD, PROMPT_FIELD, PLUGIN_ID_FIELD, ACTION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("title", TITLE_FIELD);
            this.put("id", ID_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("prompt", PROMPT_FIELD);
            this.put("pluginId", PLUGIN_ID_FIELD);
            this.put("actionIdentifier", ACTION_IDENTIFIER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String id;
    private final String type;
    private final String prompt;
    private final String pluginId;
    private final String actionIdentifier;

    private QPluginCardInput(BuilderImpl builder) {
        this.title = builder.title;
        this.id = builder.id;
        this.type = builder.type;
        this.prompt = builder.prompt;
        this.pluginId = builder.pluginId;
        this.actionIdentifier = builder.actionIdentifier;
    }

    public final String title() {
        return this.title;
    }

    public final String id() {
        return this.id;
    }

    public final CardType type() {
        return CardType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String prompt() {
        return this.prompt;
    }

    public final String pluginId() {
        return this.pluginId;
    }

    public final String actionIdentifier() {
        return this.actionIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QPluginCardInput)) {
            return false;
        }
        QPluginCardInput other = (QPluginCardInput)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.prompt(), other.prompt()) && Objects.equals(this.pluginId(), other.pluginId()) && Objects.equals(this.actionIdentifier(), other.actionIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"QPluginCardInput").add("Title", (Object)this.title()).add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Prompt", (Object)this.prompt()).add("PluginId", (Object)this.pluginId()).add("ActionIdentifier", (Object)this.actionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "prompt": {
                return Optional.ofNullable(clazz.cast(this.prompt()));
            }
            case "pluginId": {
                return Optional.ofNullable(clazz.cast(this.pluginId()));
            }
            case "actionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.actionIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QPluginCardInput, T> g) {
        return obj -> g.apply((QPluginCardInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String id;
        private String type;
        private String prompt;
        private String pluginId;
        private String actionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(QPluginCardInput model) {
            this.title(model.title);
            this.id(model.id);
            this.type(model.type);
            this.prompt(model.prompt);
            this.pluginId(model.pluginId);
            this.actionIdentifier(model.actionIdentifier);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPrompt() {
            return this.prompt;
        }

        public final void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public final Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public final String getPluginId() {
            return this.pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getActionIdentifier() {
            return this.actionIdentifier;
        }

        public final void setActionIdentifier(String actionIdentifier) {
            this.actionIdentifier = actionIdentifier;
        }

        @Override
        public final Builder actionIdentifier(String actionIdentifier) {
            this.actionIdentifier = actionIdentifier;
            return this;
        }

        public QPluginCardInput build() {
            return new QPluginCardInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QPluginCardInput> {
        public Builder title(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(CardType var1);

        public Builder prompt(String var1);

        public Builder pluginId(String var1);

        public Builder actionIdentifier(String var1);
    }
}

