/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.DocumentScope;
import software.amazon.awssdk.services.qapps.model.QAppsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportDocumentRequest
extends QAppsRequest
implements ToCopyableBuilder<Builder, ImportDocumentRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(ImportDocumentRequest.getter(ImportDocumentRequest::instanceId)).setter(ImportDocumentRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()}).build();
    private static final SdkField<String> CARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cardId").getter(ImportDocumentRequest.getter(ImportDocumentRequest::cardId)).setter(ImportDocumentRequest.setter(Builder::cardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardId").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(ImportDocumentRequest.getter(ImportDocumentRequest::appId)).setter(ImportDocumentRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> FILE_CONTENTS_BASE64_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileContentsBase64").getter(ImportDocumentRequest.getter(ImportDocumentRequest::fileContentsBase64)).setter(ImportDocumentRequest.setter(Builder::fileContentsBase64)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileContentsBase64").build()}).build();
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileName").getter(ImportDocumentRequest.getter(ImportDocumentRequest::fileName)).setter(ImportDocumentRequest.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scope").getter(ImportDocumentRequest.getter(ImportDocumentRequest::scopeAsString)).setter(ImportDocumentRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(ImportDocumentRequest.getter(ImportDocumentRequest::sessionId)).setter(ImportDocumentRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CARD_ID_FIELD, APP_ID_FIELD, FILE_CONTENTS_BASE64_FIELD, FILE_NAME_FIELD, SCOPE_FIELD, SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("instance-id", INSTANCE_ID_FIELD);
            this.put("cardId", CARD_ID_FIELD);
            this.put("appId", APP_ID_FIELD);
            this.put("fileContentsBase64", FILE_CONTENTS_BASE64_FIELD);
            this.put("fileName", FILE_NAME_FIELD);
            this.put("scope", SCOPE_FIELD);
            this.put("sessionId", SESSION_ID_FIELD);
        }
    });
    private final String instanceId;
    private final String cardId;
    private final String appId;
    private final String fileContentsBase64;
    private final String fileName;
    private final String scope;
    private final String sessionId;

    private ImportDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.cardId = builder.cardId;
        this.appId = builder.appId;
        this.fileContentsBase64 = builder.fileContentsBase64;
        this.fileName = builder.fileName;
        this.scope = builder.scope;
        this.sessionId = builder.sessionId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String cardId() {
        return this.cardId;
    }

    public final String appId() {
        return this.appId;
    }

    public final String fileContentsBase64() {
        return this.fileContentsBase64;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final DocumentScope scope() {
        return DocumentScope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileContentsBase64());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportDocumentRequest)) {
            return false;
        }
        ImportDocumentRequest other = (ImportDocumentRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.cardId(), other.cardId()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.fileContentsBase64(), other.fileContentsBase64()) && Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"ImportDocumentRequest").add("InstanceId", (Object)this.instanceId()).add("CardId", (Object)this.cardId()).add("AppId", (Object)this.appId()).add("FileContentsBase64", (Object)this.fileContentsBase64()).add("FileName", (Object)this.fileName()).add("Scope", (Object)this.scopeAsString()).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "cardId": {
                return Optional.ofNullable(clazz.cast(this.cardId()));
            }
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "fileContentsBase64": {
                return Optional.ofNullable(clazz.cast(this.fileContentsBase64()));
            }
            case "fileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportDocumentRequest, T> g) {
        return obj -> g.apply((ImportDocumentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String cardId;
        private String appId;
        private String fileContentsBase64;
        private String fileName;
        private String scope;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportDocumentRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.cardId(model.cardId);
            this.appId(model.appId);
            this.fileContentsBase64(model.fileContentsBase64);
            this.fileName(model.fileName);
            this.scope(model.scope);
            this.sessionId(model.sessionId);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getCardId() {
            return this.cardId;
        }

        public final void setCardId(String cardId) {
            this.cardId = cardId;
        }

        @Override
        public final Builder cardId(String cardId) {
            this.cardId = cardId;
            return this;
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getFileContentsBase64() {
            return this.fileContentsBase64;
        }

        public final void setFileContentsBase64(String fileContentsBase64) {
            this.fileContentsBase64 = fileContentsBase64;
        }

        @Override
        public final Builder fileContentsBase64(String fileContentsBase64) {
            this.fileContentsBase64 = fileContentsBase64;
            return this;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(DocumentScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportDocumentRequest build() {
            return new ImportDocumentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QAppsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportDocumentRequest> {
        public Builder instanceId(String var1);

        public Builder cardId(String var1);

        public Builder appId(String var1);

        public Builder fileContentsBase64(String var1);

        public Builder fileName(String var1);

        public Builder scope(String var1);

        public Builder scope(DocumentScope var1);

        public Builder sessionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

