/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.ExecutionStatus;
import software.amazon.awssdk.services.qapps.model.Submission;
import software.amazon.awssdk.services.qapps.model.SubmissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CardStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CardStatus> {
    private static final SdkField<String> CURRENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentState").getter(CardStatus.getter(CardStatus::currentStateAsString)).setter(CardStatus.setter(Builder::currentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentState").build()}).build();
    private static final SdkField<String> CURRENT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentValue").getter(CardStatus.getter(CardStatus::currentValue)).setter(CardStatus.setter(Builder::currentValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentValue").build()}).build();
    private static final SdkField<List<Submission>> SUBMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("submissions").getter(CardStatus.getter(CardStatus::submissions)).setter(CardStatus.setter(Builder::submissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Submission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_STATE_FIELD, CURRENT_VALUE_FIELD, SUBMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("currentState", CURRENT_STATE_FIELD);
            this.put("currentValue", CURRENT_VALUE_FIELD);
            this.put("submissions", SUBMISSIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String currentState;
    private final String currentValue;
    private final List<Submission> submissions;

    private CardStatus(BuilderImpl builder) {
        this.currentState = builder.currentState;
        this.currentValue = builder.currentValue;
        this.submissions = builder.submissions;
    }

    public final ExecutionStatus currentState() {
        return ExecutionStatus.fromValue(this.currentState);
    }

    public final String currentStateAsString() {
        return this.currentState;
    }

    public final String currentValue() {
        return this.currentValue;
    }

    public final boolean hasSubmissions() {
        return this.submissions != null && !(this.submissions instanceof SdkAutoConstructList);
    }

    public final List<Submission> submissions() {
        return this.submissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubmissions() ? this.submissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CardStatus)) {
            return false;
        }
        CardStatus other = (CardStatus)obj;
        return Objects.equals(this.currentStateAsString(), other.currentStateAsString()) && Objects.equals(this.currentValue(), other.currentValue()) && this.hasSubmissions() == other.hasSubmissions() && Objects.equals(this.submissions(), other.submissions());
    }

    public final String toString() {
        return ToString.builder((String)"CardStatus").add("CurrentState", (Object)this.currentStateAsString()).add("CurrentValue", (Object)this.currentValue()).add("Submissions", this.hasSubmissions() ? this.submissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currentState": {
                return Optional.ofNullable(clazz.cast(this.currentStateAsString()));
            }
            case "currentValue": {
                return Optional.ofNullable(clazz.cast(this.currentValue()));
            }
            case "submissions": {
                return Optional.ofNullable(clazz.cast(this.submissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CardStatus, T> g) {
        return obj -> g.apply((CardStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currentState;
        private String currentValue;
        private List<Submission> submissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CardStatus model) {
            this.currentState(model.currentState);
            this.currentValue(model.currentValue);
            this.submissions(model.submissions);
        }

        public final String getCurrentState() {
            return this.currentState;
        }

        public final void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        @Override
        public final Builder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @Override
        public final Builder currentState(ExecutionStatus currentState) {
            this.currentState(currentState == null ? null : currentState.toString());
            return this;
        }

        public final String getCurrentValue() {
            return this.currentValue;
        }

        public final void setCurrentValue(String currentValue) {
            this.currentValue = currentValue;
        }

        @Override
        public final Builder currentValue(String currentValue) {
            this.currentValue = currentValue;
            return this;
        }

        public final List<Submission.Builder> getSubmissions() {
            List<Submission.Builder> result = SubmissionListCopier.copyToBuilder(this.submissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubmissions(Collection<Submission.BuilderImpl> submissions) {
            this.submissions = SubmissionListCopier.copyFromBuilder(submissions);
        }

        @Override
        public final Builder submissions(Collection<Submission> submissions) {
            this.submissions = SubmissionListCopier.copy(submissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder submissions(Submission ... submissions) {
            this.submissions(Arrays.asList(submissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder submissions(Consumer<Submission.Builder> ... submissions) {
            this.submissions(Stream.of(submissions).map(c -> (Submission)((Submission.Builder)Submission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CardStatus build() {
            return new CardStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CardStatus> {
        public Builder currentState(String var1);

        public Builder currentState(ExecutionStatus var1);

        public Builder currentValue(String var1);

        public Builder submissions(Collection<Submission> var1);

        public Builder submissions(Submission ... var1);

        public Builder submissions(Consumer<Submission.Builder> ... var1);
    }
}

