/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.QAppsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLibraryItemRequest
extends QAppsRequest
implements ToCopyableBuilder<Builder, DeleteLibraryItemRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(DeleteLibraryItemRequest.getter(DeleteLibraryItemRequest::instanceId)).setter(DeleteLibraryItemRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()}).build();
    private static final SdkField<String> LIBRARY_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("libraryItemId").getter(DeleteLibraryItemRequest.getter(DeleteLibraryItemRequest::libraryItemId)).setter(DeleteLibraryItemRequest.setter(Builder::libraryItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryItemId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, LIBRARY_ITEM_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("instance-id", INSTANCE_ID_FIELD);
            this.put("libraryItemId", LIBRARY_ITEM_ID_FIELD);
        }
    });
    private final String instanceId;
    private final String libraryItemId;

    private DeleteLibraryItemRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.libraryItemId = builder.libraryItemId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String libraryItemId() {
        return this.libraryItemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.libraryItemId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLibraryItemRequest)) {
            return false;
        }
        DeleteLibraryItemRequest other = (DeleteLibraryItemRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.libraryItemId(), other.libraryItemId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteLibraryItemRequest").add("InstanceId", (Object)this.instanceId()).add("LibraryItemId", (Object)this.libraryItemId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "libraryItemId": {
                return Optional.ofNullable(clazz.cast(this.libraryItemId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLibraryItemRequest, T> g) {
        return obj -> g.apply((DeleteLibraryItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String libraryItemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLibraryItemRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.libraryItemId(model.libraryItemId);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getLibraryItemId() {
            return this.libraryItemId;
        }

        public final void setLibraryItemId(String libraryItemId) {
            this.libraryItemId = libraryItemId;
        }

        @Override
        public final Builder libraryItemId(String libraryItemId) {
            this.libraryItemId = libraryItemId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLibraryItemRequest build() {
            return new DeleteLibraryItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QAppsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteLibraryItemRequest> {
        public Builder instanceId(String var1);

        public Builder libraryItemId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

