/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qapps.model.FileUploadCard;
import software.amazon.awssdk.services.qapps.model.QPluginCard;
import software.amazon.awssdk.services.qapps.model.QQueryCard;
import software.amazon.awssdk.services.qapps.model.TextInputCard;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Card
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Card> {
    private static final SdkField<TextInputCard> TEXT_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("textInput").getter(Card.getter(Card::textInput)).setter(Card.setter(Builder::textInput)).constructor(TextInputCard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textInput").build()}).build();
    private static final SdkField<QQueryCard> Q_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("qQuery").getter(Card.getter(Card::qQuery)).setter(Card.setter(Builder::qQuery)).constructor(QQueryCard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qQuery").build()}).build();
    private static final SdkField<QPluginCard> Q_PLUGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("qPlugin").getter(Card.getter(Card::qPlugin)).setter(Card.setter(Builder::qPlugin)).constructor(QPluginCard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qPlugin").build()}).build();
    private static final SdkField<FileUploadCard> FILE_UPLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fileUpload").getter(Card.getter(Card::fileUpload)).setter(Card.setter(Builder::fileUpload)).constructor(FileUploadCard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileUpload").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_INPUT_FIELD, Q_QUERY_FIELD, Q_PLUGIN_FIELD, FILE_UPLOAD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("textInput", TEXT_INPUT_FIELD);
            this.put("qQuery", Q_QUERY_FIELD);
            this.put("qPlugin", Q_PLUGIN_FIELD);
            this.put("fileUpload", FILE_UPLOAD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final TextInputCard textInput;
    private final QQueryCard qQuery;
    private final QPluginCard qPlugin;
    private final FileUploadCard fileUpload;
    private final Type type;

    private Card(BuilderImpl builder) {
        this.textInput = builder.textInput;
        this.qQuery = builder.qQuery;
        this.qPlugin = builder.qPlugin;
        this.fileUpload = builder.fileUpload;
        this.type = builder.type;
    }

    public final TextInputCard textInput() {
        return this.textInput;
    }

    public final QQueryCard qQuery() {
        return this.qQuery;
    }

    public final QPluginCard qPlugin() {
        return this.qPlugin;
    }

    public final FileUploadCard fileUpload() {
        return this.fileUpload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.qQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.qPlugin());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileUpload());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Card)) {
            return false;
        }
        Card other = (Card)obj;
        return Objects.equals(this.textInput(), other.textInput()) && Objects.equals(this.qQuery(), other.qQuery()) && Objects.equals(this.qPlugin(), other.qPlugin()) && Objects.equals(this.fileUpload(), other.fileUpload());
    }

    public final String toString() {
        return ToString.builder((String)"Card").add("TextInput", (Object)this.textInput()).add("QQuery", (Object)this.qQuery()).add("QPlugin", (Object)this.qPlugin()).add("FileUpload", (Object)this.fileUpload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "textInput": {
                return Optional.ofNullable(clazz.cast(this.textInput()));
            }
            case "qQuery": {
                return Optional.ofNullable(clazz.cast(this.qQuery()));
            }
            case "qPlugin": {
                return Optional.ofNullable(clazz.cast(this.qPlugin()));
            }
            case "fileUpload": {
                return Optional.ofNullable(clazz.cast(this.fileUpload()));
            }
        }
        return Optional.empty();
    }

    public static Card fromTextInput(TextInputCard textInput) {
        return (Card)Card.builder().textInput(textInput).build();
    }

    public static Card fromTextInput(Consumer<TextInputCard.Builder> textInput) {
        TextInputCard.Builder builder = TextInputCard.builder();
        textInput.accept(builder);
        return Card.fromTextInput((TextInputCard)builder.build());
    }

    public static Card fromQQuery(QQueryCard qQuery) {
        return (Card)Card.builder().qQuery(qQuery).build();
    }

    public static Card fromQQuery(Consumer<QQueryCard.Builder> qQuery) {
        QQueryCard.Builder builder = QQueryCard.builder();
        qQuery.accept(builder);
        return Card.fromQQuery((QQueryCard)builder.build());
    }

    public static Card fromQPlugin(QPluginCard qPlugin) {
        return (Card)Card.builder().qPlugin(qPlugin).build();
    }

    public static Card fromQPlugin(Consumer<QPluginCard.Builder> qPlugin) {
        QPluginCard.Builder builder = QPluginCard.builder();
        qPlugin.accept(builder);
        return Card.fromQPlugin((QPluginCard)builder.build());
    }

    public static Card fromFileUpload(FileUploadCard fileUpload) {
        return (Card)Card.builder().fileUpload(fileUpload).build();
    }

    public static Card fromFileUpload(Consumer<FileUploadCard.Builder> fileUpload) {
        FileUploadCard.Builder builder = FileUploadCard.builder();
        fileUpload.accept(builder);
        return Card.fromFileUpload((FileUploadCard)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Card, T> g) {
        return obj -> g.apply((Card)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT_INPUT,
        Q_QUERY,
        Q_PLUGIN,
        FILE_UPLOAD,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private TextInputCard textInput;
        private QQueryCard qQuery;
        private QPluginCard qPlugin;
        private FileUploadCard fileUpload;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Card model) {
            this.textInput(model.textInput);
            this.qQuery(model.qQuery);
            this.qPlugin(model.qPlugin);
            this.fileUpload(model.fileUpload);
        }

        public final TextInputCard.Builder getTextInput() {
            return this.textInput != null ? this.textInput.toBuilder() : null;
        }

        public final void setTextInput(TextInputCard.BuilderImpl textInput) {
            TextInputCard oldValue = this.textInput;
            this.textInput = textInput != null ? textInput.build() : null;
            this.handleUnionValueChange(Type.TEXT_INPUT, oldValue, this.textInput);
        }

        @Override
        public final Builder textInput(TextInputCard textInput) {
            TextInputCard oldValue = this.textInput;
            this.textInput = textInput;
            this.handleUnionValueChange(Type.TEXT_INPUT, oldValue, this.textInput);
            return this;
        }

        public final QQueryCard.Builder getQQuery() {
            return this.qQuery != null ? this.qQuery.toBuilder() : null;
        }

        public final void setQQuery(QQueryCard.BuilderImpl qQuery) {
            QQueryCard oldValue = this.qQuery;
            this.qQuery = qQuery != null ? qQuery.build() : null;
            this.handleUnionValueChange(Type.Q_QUERY, oldValue, this.qQuery);
        }

        @Override
        public final Builder qQuery(QQueryCard qQuery) {
            QQueryCard oldValue = this.qQuery;
            this.qQuery = qQuery;
            this.handleUnionValueChange(Type.Q_QUERY, oldValue, this.qQuery);
            return this;
        }

        public final QPluginCard.Builder getQPlugin() {
            return this.qPlugin != null ? this.qPlugin.toBuilder() : null;
        }

        public final void setQPlugin(QPluginCard.BuilderImpl qPlugin) {
            QPluginCard oldValue = this.qPlugin;
            this.qPlugin = qPlugin != null ? qPlugin.build() : null;
            this.handleUnionValueChange(Type.Q_PLUGIN, oldValue, this.qPlugin);
        }

        @Override
        public final Builder qPlugin(QPluginCard qPlugin) {
            QPluginCard oldValue = this.qPlugin;
            this.qPlugin = qPlugin;
            this.handleUnionValueChange(Type.Q_PLUGIN, oldValue, this.qPlugin);
            return this;
        }

        public final FileUploadCard.Builder getFileUpload() {
            return this.fileUpload != null ? this.fileUpload.toBuilder() : null;
        }

        public final void setFileUpload(FileUploadCard.BuilderImpl fileUpload) {
            FileUploadCard oldValue = this.fileUpload;
            this.fileUpload = fileUpload != null ? fileUpload.build() : null;
            this.handleUnionValueChange(Type.FILE_UPLOAD, oldValue, this.fileUpload);
        }

        @Override
        public final Builder fileUpload(FileUploadCard fileUpload) {
            FileUploadCard oldValue = this.fileUpload;
            this.fileUpload = fileUpload;
            this.handleUnionValueChange(Type.FILE_UPLOAD, oldValue, this.fileUpload);
            return this;
        }

        public Card build() {
            return new Card(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Card> {
        public Builder textInput(TextInputCard var1);

        default public Builder textInput(Consumer<TextInputCard.Builder> textInput) {
            return this.textInput((TextInputCard)((TextInputCard.Builder)TextInputCard.builder().applyMutation(textInput)).build());
        }

        public Builder qQuery(QQueryCard var1);

        default public Builder qQuery(Consumer<QQueryCard.Builder> qQuery) {
            return this.qQuery((QQueryCard)((QQueryCard.Builder)QQueryCard.builder().applyMutation(qQuery)).build());
        }

        public Builder qPlugin(QPluginCard var1);

        default public Builder qPlugin(Consumer<QPluginCard.Builder> qPlugin) {
            return this.qPlugin((QPluginCard)((QPluginCard.Builder)QPluginCard.builder().applyMutation(qPlugin)).build());
        }

        public Builder fileUpload(FileUploadCard var1);

        default public Builder fileUpload(Consumer<FileUploadCard.Builder> fileUpload) {
            return this.fileUpload((FileUploadCard)((FileUploadCard.Builder)FileUploadCard.builder().applyMutation(fileUpload)).build());
        }
    }
}

