/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.Category;
import software.amazon.awssdk.services.qapps.model.CategoryListCopier;
import software.amazon.awssdk.services.qapps.model.QAppsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLibraryItemResponse
extends QAppsResponse
implements ToCopyableBuilder<Builder, UpdateLibraryItemResponse> {
    private static final SdkField<String> LIBRARY_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("libraryItemId").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::libraryItemId)).setter(UpdateLibraryItemResponse.setter(Builder::libraryItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryItemId").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::appId)).setter(UpdateLibraryItemResponse.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<Integer> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("appVersion").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::appVersion)).setter(UpdateLibraryItemResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<List<Category>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("categories").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::categories)).setter(UpdateLibraryItemResponse.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Category::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::status)).setter(UpdateLibraryItemResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::createdAt)).setter(UpdateLibraryItemResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::createdBy)).setter(UpdateLibraryItemResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::updatedAt)).setter(UpdateLibraryItemResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::updatedBy)).setter(UpdateLibraryItemResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<Integer> RATING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ratingCount").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::ratingCount)).setter(UpdateLibraryItemResponse.setter(Builder::ratingCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ratingCount").build()}).build();
    private static final SdkField<Boolean> IS_RATED_BY_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRatedByUser").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::isRatedByUser)).setter(UpdateLibraryItemResponse.setter(Builder::isRatedByUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRatedByUser").build()}).build();
    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("userCount").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::userCount)).setter(UpdateLibraryItemResponse.setter(Builder::userCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userCount").build()}).build();
    private static final SdkField<Boolean> IS_VERIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isVerified").getter(UpdateLibraryItemResponse.getter(UpdateLibraryItemResponse::isVerified)).setter(UpdateLibraryItemResponse.setter(Builder::isVerified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isVerified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIBRARY_ITEM_ID_FIELD, APP_ID_FIELD, APP_VERSION_FIELD, CATEGORIES_FIELD, STATUS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, RATING_COUNT_FIELD, IS_RATED_BY_USER_FIELD, USER_COUNT_FIELD, IS_VERIFIED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("libraryItemId", LIBRARY_ITEM_ID_FIELD);
            this.put("appId", APP_ID_FIELD);
            this.put("appVersion", APP_VERSION_FIELD);
            this.put("categories", CATEGORIES_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("updatedBy", UPDATED_BY_FIELD);
            this.put("ratingCount", RATING_COUNT_FIELD);
            this.put("isRatedByUser", IS_RATED_BY_USER_FIELD);
            this.put("userCount", USER_COUNT_FIELD);
            this.put("isVerified", IS_VERIFIED_FIELD);
        }
    });
    private final String libraryItemId;
    private final String appId;
    private final Integer appVersion;
    private final List<Category> categories;
    private final String status;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant updatedAt;
    private final String updatedBy;
    private final Integer ratingCount;
    private final Boolean isRatedByUser;
    private final Integer userCount;
    private final Boolean isVerified;

    private UpdateLibraryItemResponse(BuilderImpl builder) {
        super(builder);
        this.libraryItemId = builder.libraryItemId;
        this.appId = builder.appId;
        this.appVersion = builder.appVersion;
        this.categories = builder.categories;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.ratingCount = builder.ratingCount;
        this.isRatedByUser = builder.isRatedByUser;
        this.userCount = builder.userCount;
        this.isVerified = builder.isVerified;
    }

    public final String libraryItemId() {
        return this.libraryItemId;
    }

    public final String appId() {
        return this.appId;
    }

    public final Integer appVersion() {
        return this.appVersion;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<Category> categories() {
        return this.categories;
    }

    public final String status() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final Integer ratingCount() {
        return this.ratingCount;
    }

    public final Boolean isRatedByUser() {
        return this.isRatedByUser;
    }

    public final Integer userCount() {
        return this.userCount;
    }

    public final Boolean isVerified() {
        return this.isVerified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.libraryItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.ratingCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRatedByUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.isVerified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLibraryItemResponse)) {
            return false;
        }
        UpdateLibraryItemResponse other = (UpdateLibraryItemResponse)((Object)obj);
        return Objects.equals(this.libraryItemId(), other.libraryItemId()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.appVersion(), other.appVersion()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.ratingCount(), other.ratingCount()) && Objects.equals(this.isRatedByUser(), other.isRatedByUser()) && Objects.equals(this.userCount(), other.userCount()) && Objects.equals(this.isVerified(), other.isVerified());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLibraryItemResponse").add("LibraryItemId", (Object)this.libraryItemId()).add("AppId", (Object)this.appId()).add("AppVersion", (Object)this.appVersion()).add("Categories", this.hasCategories() ? this.categories() : null).add("Status", (Object)this.status()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("RatingCount", (Object)this.ratingCount()).add("IsRatedByUser", (Object)this.isRatedByUser()).add("UserCount", (Object)this.userCount()).add("IsVerified", (Object)this.isVerified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "libraryItemId": {
                return Optional.ofNullable(clazz.cast(this.libraryItemId()));
            }
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "ratingCount": {
                return Optional.ofNullable(clazz.cast(this.ratingCount()));
            }
            case "isRatedByUser": {
                return Optional.ofNullable(clazz.cast(this.isRatedByUser()));
            }
            case "userCount": {
                return Optional.ofNullable(clazz.cast(this.userCount()));
            }
            case "isVerified": {
                return Optional.ofNullable(clazz.cast(this.isVerified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLibraryItemResponse, T> g) {
        return obj -> g.apply((UpdateLibraryItemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsResponse.BuilderImpl
    implements Builder {
        private String libraryItemId;
        private String appId;
        private Integer appVersion;
        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Instant createdAt;
        private String createdBy;
        private Instant updatedAt;
        private String updatedBy;
        private Integer ratingCount;
        private Boolean isRatedByUser;
        private Integer userCount;
        private Boolean isVerified;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLibraryItemResponse model) {
            super(model);
            this.libraryItemId(model.libraryItemId);
            this.appId(model.appId);
            this.appVersion(model.appVersion);
            this.categories(model.categories);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.ratingCount(model.ratingCount);
            this.isRatedByUser(model.isRatedByUser);
            this.userCount(model.userCount);
            this.isVerified(model.isVerified);
        }

        public final String getLibraryItemId() {
            return this.libraryItemId;
        }

        public final void setLibraryItemId(String libraryItemId) {
            this.libraryItemId = libraryItemId;
        }

        @Override
        public final Builder libraryItemId(String libraryItemId) {
            this.libraryItemId = libraryItemId;
            return this;
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final Integer getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(Integer appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(Integer appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final List<Category.Builder> getCategories() {
            List<Category.Builder> result = CategoryListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder> ... categories) {
            this.categories(Stream.of(categories).map(c -> (Category)((Category.Builder)Category.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Integer getRatingCount() {
            return this.ratingCount;
        }

        public final void setRatingCount(Integer ratingCount) {
            this.ratingCount = ratingCount;
        }

        @Override
        public final Builder ratingCount(Integer ratingCount) {
            this.ratingCount = ratingCount;
            return this;
        }

        public final Boolean getIsRatedByUser() {
            return this.isRatedByUser;
        }

        public final void setIsRatedByUser(Boolean isRatedByUser) {
            this.isRatedByUser = isRatedByUser;
        }

        @Override
        public final Builder isRatedByUser(Boolean isRatedByUser) {
            this.isRatedByUser = isRatedByUser;
            return this;
        }

        public final Integer getUserCount() {
            return this.userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final Boolean getIsVerified() {
            return this.isVerified;
        }

        public final void setIsVerified(Boolean isVerified) {
            this.isVerified = isVerified;
        }

        @Override
        public final Builder isVerified(Boolean isVerified) {
            this.isVerified = isVerified;
            return this;
        }

        @Override
        public UpdateLibraryItemResponse build() {
            return new UpdateLibraryItemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QAppsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLibraryItemResponse> {
        public Builder libraryItemId(String var1);

        public Builder appId(String var1);

        public Builder appVersion(Integer var1);

        public Builder categories(Collection<Category> var1);

        public Builder categories(Category ... var1);

        public Builder categories(Consumer<Category.Builder> ... var1);

        public Builder status(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder ratingCount(Integer var1);

        public Builder isRatedByUser(Boolean var1);

        public Builder userCount(Integer var1);

        public Builder isVerified(Boolean var1);
    }
}

