/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qapps.model.CardValue;
import software.amazon.awssdk.services.qapps.model.CardValueListCopier;
import software.amazon.awssdk.services.qapps.model.QAppsRequest;
import software.amazon.awssdk.services.qapps.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartQAppSessionRequest
extends QAppsRequest
implements ToCopyableBuilder<Builder, StartQAppSessionRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(StartQAppSessionRequest.getter(StartQAppSessionRequest::instanceId)).setter(StartQAppSessionRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("instance-id").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(StartQAppSessionRequest.getter(StartQAppSessionRequest::appId)).setter(StartQAppSessionRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<Integer> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("appVersion").getter(StartQAppSessionRequest.getter(StartQAppSessionRequest::appVersion)).setter(StartQAppSessionRequest.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<List<CardValue>> INITIAL_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("initialValues").getter(StartQAppSessionRequest.getter(StartQAppSessionRequest::initialValues)).setter(StartQAppSessionRequest.setter(Builder::initialValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CardValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartQAppSessionRequest.getter(StartQAppSessionRequest::tags)).setter(StartQAppSessionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, APP_ID_FIELD, APP_VERSION_FIELD, INITIAL_VALUES_FIELD, TAGS_FIELD));
    private final String instanceId;
    private final String appId;
    private final Integer appVersion;
    private final List<CardValue> initialValues;
    private final Map<String, String> tags;

    private StartQAppSessionRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.appId = builder.appId;
        this.appVersion = builder.appVersion;
        this.initialValues = builder.initialValues;
        this.tags = builder.tags;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String appId() {
        return this.appId;
    }

    public final Integer appVersion() {
        return this.appVersion;
    }

    public final boolean hasInitialValues() {
        return this.initialValues != null && !(this.initialValues instanceof SdkAutoConstructList);
    }

    public final List<CardValue> initialValues() {
        return this.initialValues;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInitialValues() ? this.initialValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQAppSessionRequest)) {
            return false;
        }
        StartQAppSessionRequest other = (StartQAppSessionRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.appVersion(), other.appVersion()) && this.hasInitialValues() == other.hasInitialValues() && Objects.equals(this.initialValues(), other.initialValues()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartQAppSessionRequest").add("InstanceId", (Object)this.instanceId()).add("AppId", (Object)this.appId()).add("AppVersion", (Object)this.appVersion()).add("InitialValues", this.hasInitialValues() ? this.initialValues() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "initialValues": {
                return Optional.ofNullable(clazz.cast(this.initialValues()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartQAppSessionRequest, T> g) {
        return obj -> g.apply((StartQAppSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String appId;
        private Integer appVersion;
        private List<CardValue> initialValues = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartQAppSessionRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.appId(model.appId);
            this.appVersion(model.appVersion);
            this.initialValues(model.initialValues);
            this.tags(model.tags);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final Integer getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(Integer appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(Integer appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final List<CardValue.Builder> getInitialValues() {
            List<CardValue.Builder> result = CardValueListCopier.copyToBuilder(this.initialValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInitialValues(Collection<CardValue.BuilderImpl> initialValues) {
            this.initialValues = CardValueListCopier.copyFromBuilder(initialValues);
        }

        @Override
        public final Builder initialValues(Collection<CardValue> initialValues) {
            this.initialValues = CardValueListCopier.copy(initialValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initialValues(CardValue ... initialValues) {
            this.initialValues(Arrays.asList(initialValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initialValues(Consumer<CardValue.Builder> ... initialValues) {
            this.initialValues(Stream.of(initialValues).map(c -> (CardValue)((CardValue.Builder)CardValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQAppSessionRequest build() {
            return new StartQAppSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QAppsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartQAppSessionRequest> {
        public Builder instanceId(String var1);

        public Builder appId(String var1);

        public Builder appVersion(Integer var1);

        public Builder initialValues(Collection<CardValue> var1);

        public Builder initialValues(CardValue ... var1);

        public Builder initialValues(Consumer<CardValue.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

