/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.ResourceCountsSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CountsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CountsSummary> {
    private static final SdkField<ResourceCountsSummary> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("components").getter(CountsSummary.getter(CountsSummary::components)).setter(CountsSummary.setter(Builder::components)).constructor(ResourceCountsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build()}).build();
    private static final SdkField<ResourceCountsSummary> ENVIRONMENT_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environmentTemplates").getter(CountsSummary.getter(CountsSummary::environmentTemplates)).setter(CountsSummary.setter(Builder::environmentTemplates)).constructor(ResourceCountsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentTemplates").build()}).build();
    private static final SdkField<ResourceCountsSummary> ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environments").getter(CountsSummary.getter(CountsSummary::environments)).setter(CountsSummary.setter(Builder::environments)).constructor(ResourceCountsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environments").build()}).build();
    private static final SdkField<ResourceCountsSummary> PIPELINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pipelines").getter(CountsSummary.getter(CountsSummary::pipelines)).setter(CountsSummary.setter(Builder::pipelines)).constructor(ResourceCountsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelines").build()}).build();
    private static final SdkField<ResourceCountsSummary> SERVICE_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceInstances").getter(CountsSummary.getter(CountsSummary::serviceInstances)).setter(CountsSummary.setter(Builder::serviceInstances)).constructor(ResourceCountsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstances").build()}).build();
    private static final SdkField<ResourceCountsSummary> SERVICE_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceTemplates").getter(CountsSummary.getter(CountsSummary::serviceTemplates)).setter(CountsSummary.setter(Builder::serviceTemplates)).constructor(ResourceCountsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceTemplates").build()}).build();
    private static final SdkField<ResourceCountsSummary> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("services").getter(CountsSummary.getter(CountsSummary::services)).setter(CountsSummary.setter(Builder::services)).constructor(ResourceCountsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENTS_FIELD, ENVIRONMENT_TEMPLATES_FIELD, ENVIRONMENTS_FIELD, PIPELINES_FIELD, SERVICE_INSTANCES_FIELD, SERVICE_TEMPLATES_FIELD, SERVICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CountsSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ResourceCountsSummary components;
    private final ResourceCountsSummary environmentTemplates;
    private final ResourceCountsSummary environments;
    private final ResourceCountsSummary pipelines;
    private final ResourceCountsSummary serviceInstances;
    private final ResourceCountsSummary serviceTemplates;
    private final ResourceCountsSummary services;

    private CountsSummary(BuilderImpl builder) {
        this.components = builder.components;
        this.environmentTemplates = builder.environmentTemplates;
        this.environments = builder.environments;
        this.pipelines = builder.pipelines;
        this.serviceInstances = builder.serviceInstances;
        this.serviceTemplates = builder.serviceTemplates;
        this.services = builder.services;
    }

    public final ResourceCountsSummary components() {
        return this.components;
    }

    public final ResourceCountsSummary environmentTemplates() {
        return this.environmentTemplates;
    }

    public final ResourceCountsSummary environments() {
        return this.environments;
    }

    public final ResourceCountsSummary pipelines() {
        return this.pipelines;
    }

    public final ResourceCountsSummary serviceInstances() {
        return this.serviceInstances;
    }

    public final ResourceCountsSummary serviceTemplates() {
        return this.serviceTemplates;
    }

    public final ResourceCountsSummary services() {
        return this.services;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.components());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.environments());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelines());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.services());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountsSummary)) {
            return false;
        }
        CountsSummary other = (CountsSummary)obj;
        return Objects.equals(this.components(), other.components()) && Objects.equals(this.environmentTemplates(), other.environmentTemplates()) && Objects.equals(this.environments(), other.environments()) && Objects.equals(this.pipelines(), other.pipelines()) && Objects.equals(this.serviceInstances(), other.serviceInstances()) && Objects.equals(this.serviceTemplates(), other.serviceTemplates()) && Objects.equals(this.services(), other.services());
    }

    public final String toString() {
        return ToString.builder((String)"CountsSummary").add("Components", (Object)this.components()).add("EnvironmentTemplates", (Object)this.environmentTemplates()).add("Environments", (Object)this.environments()).add("Pipelines", (Object)this.pipelines()).add("ServiceInstances", (Object)this.serviceInstances()).add("ServiceTemplates", (Object)this.serviceTemplates()).add("Services", (Object)this.services()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
            case "environmentTemplates": {
                return Optional.ofNullable(clazz.cast(this.environmentTemplates()));
            }
            case "environments": {
                return Optional.ofNullable(clazz.cast(this.environments()));
            }
            case "pipelines": {
                return Optional.ofNullable(clazz.cast(this.pipelines()));
            }
            case "serviceInstances": {
                return Optional.ofNullable(clazz.cast(this.serviceInstances()));
            }
            case "serviceTemplates": {
                return Optional.ofNullable(clazz.cast(this.serviceTemplates()));
            }
            case "services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<ResourceCountsSummary>> map = new HashMap<String, SdkField<ResourceCountsSummary>>();
        map.put("components", COMPONENTS_FIELD);
        map.put("environmentTemplates", ENVIRONMENT_TEMPLATES_FIELD);
        map.put("environments", ENVIRONMENTS_FIELD);
        map.put("pipelines", PIPELINES_FIELD);
        map.put("serviceInstances", SERVICE_INSTANCES_FIELD);
        map.put("serviceTemplates", SERVICE_TEMPLATES_FIELD);
        map.put("services", SERVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CountsSummary, T> g) {
        return obj -> g.apply((CountsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceCountsSummary components;
        private ResourceCountsSummary environmentTemplates;
        private ResourceCountsSummary environments;
        private ResourceCountsSummary pipelines;
        private ResourceCountsSummary serviceInstances;
        private ResourceCountsSummary serviceTemplates;
        private ResourceCountsSummary services;

        private BuilderImpl() {
        }

        private BuilderImpl(CountsSummary model) {
            this.components(model.components);
            this.environmentTemplates(model.environmentTemplates);
            this.environments(model.environments);
            this.pipelines(model.pipelines);
            this.serviceInstances(model.serviceInstances);
            this.serviceTemplates(model.serviceTemplates);
            this.services(model.services);
        }

        public final ResourceCountsSummary.Builder getComponents() {
            return this.components != null ? this.components.toBuilder() : null;
        }

        public final void setComponents(ResourceCountsSummary.BuilderImpl components) {
            this.components = components != null ? components.build() : null;
        }

        @Override
        public final Builder components(ResourceCountsSummary components) {
            this.components = components;
            return this;
        }

        public final ResourceCountsSummary.Builder getEnvironmentTemplates() {
            return this.environmentTemplates != null ? this.environmentTemplates.toBuilder() : null;
        }

        public final void setEnvironmentTemplates(ResourceCountsSummary.BuilderImpl environmentTemplates) {
            this.environmentTemplates = environmentTemplates != null ? environmentTemplates.build() : null;
        }

        @Override
        public final Builder environmentTemplates(ResourceCountsSummary environmentTemplates) {
            this.environmentTemplates = environmentTemplates;
            return this;
        }

        public final ResourceCountsSummary.Builder getEnvironments() {
            return this.environments != null ? this.environments.toBuilder() : null;
        }

        public final void setEnvironments(ResourceCountsSummary.BuilderImpl environments) {
            this.environments = environments != null ? environments.build() : null;
        }

        @Override
        public final Builder environments(ResourceCountsSummary environments) {
            this.environments = environments;
            return this;
        }

        public final ResourceCountsSummary.Builder getPipelines() {
            return this.pipelines != null ? this.pipelines.toBuilder() : null;
        }

        public final void setPipelines(ResourceCountsSummary.BuilderImpl pipelines) {
            this.pipelines = pipelines != null ? pipelines.build() : null;
        }

        @Override
        public final Builder pipelines(ResourceCountsSummary pipelines) {
            this.pipelines = pipelines;
            return this;
        }

        public final ResourceCountsSummary.Builder getServiceInstances() {
            return this.serviceInstances != null ? this.serviceInstances.toBuilder() : null;
        }

        public final void setServiceInstances(ResourceCountsSummary.BuilderImpl serviceInstances) {
            this.serviceInstances = serviceInstances != null ? serviceInstances.build() : null;
        }

        @Override
        public final Builder serviceInstances(ResourceCountsSummary serviceInstances) {
            this.serviceInstances = serviceInstances;
            return this;
        }

        public final ResourceCountsSummary.Builder getServiceTemplates() {
            return this.serviceTemplates != null ? this.serviceTemplates.toBuilder() : null;
        }

        public final void setServiceTemplates(ResourceCountsSummary.BuilderImpl serviceTemplates) {
            this.serviceTemplates = serviceTemplates != null ? serviceTemplates.build() : null;
        }

        @Override
        public final Builder serviceTemplates(ResourceCountsSummary serviceTemplates) {
            this.serviceTemplates = serviceTemplates;
            return this;
        }

        public final ResourceCountsSummary.Builder getServices() {
            return this.services != null ? this.services.toBuilder() : null;
        }

        public final void setServices(ResourceCountsSummary.BuilderImpl services) {
            this.services = services != null ? services.build() : null;
        }

        @Override
        public final Builder services(ResourceCountsSummary services) {
            this.services = services;
            return this;
        }

        public CountsSummary build() {
            return new CountsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CountsSummary> {
        public Builder components(ResourceCountsSummary var1);

        default public Builder components(Consumer<ResourceCountsSummary.Builder> components) {
            return this.components((ResourceCountsSummary)((ResourceCountsSummary.Builder)ResourceCountsSummary.builder().applyMutation(components)).build());
        }

        public Builder environmentTemplates(ResourceCountsSummary var1);

        default public Builder environmentTemplates(Consumer<ResourceCountsSummary.Builder> environmentTemplates) {
            return this.environmentTemplates((ResourceCountsSummary)((ResourceCountsSummary.Builder)ResourceCountsSummary.builder().applyMutation(environmentTemplates)).build());
        }

        public Builder environments(ResourceCountsSummary var1);

        default public Builder environments(Consumer<ResourceCountsSummary.Builder> environments) {
            return this.environments((ResourceCountsSummary)((ResourceCountsSummary.Builder)ResourceCountsSummary.builder().applyMutation(environments)).build());
        }

        public Builder pipelines(ResourceCountsSummary var1);

        default public Builder pipelines(Consumer<ResourceCountsSummary.Builder> pipelines) {
            return this.pipelines((ResourceCountsSummary)((ResourceCountsSummary.Builder)ResourceCountsSummary.builder().applyMutation(pipelines)).build());
        }

        public Builder serviceInstances(ResourceCountsSummary var1);

        default public Builder serviceInstances(Consumer<ResourceCountsSummary.Builder> serviceInstances) {
            return this.serviceInstances((ResourceCountsSummary)((ResourceCountsSummary.Builder)ResourceCountsSummary.builder().applyMutation(serviceInstances)).build());
        }

        public Builder serviceTemplates(ResourceCountsSummary var1);

        default public Builder serviceTemplates(Consumer<ResourceCountsSummary.Builder> serviceTemplates) {
            return this.serviceTemplates((ResourceCountsSummary)((ResourceCountsSummary.Builder)ResourceCountsSummary.builder().applyMutation(serviceTemplates)).build());
        }

        public Builder services(ResourceCountsSummary var1);

        default public Builder services(Consumer<ResourceCountsSummary.Builder> services) {
            return this.services((ResourceCountsSummary)((ResourceCountsSummary.Builder)ResourceCountsSummary.builder().applyMutation(services)).build());
        }
    }
}

