/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.RepositoryBranch;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountSettings> {
    private static final SdkField<String> PIPELINE_CODEBUILD_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineCodebuildRoleArn").getter(AccountSettings.getter(AccountSettings::pipelineCodebuildRoleArn)).setter(AccountSettings.setter(Builder::pipelineCodebuildRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineCodebuildRoleArn").build()}).build();
    private static final SdkField<RepositoryBranch> PIPELINE_PROVISIONING_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pipelineProvisioningRepository").getter(AccountSettings.getter(AccountSettings::pipelineProvisioningRepository)).setter(AccountSettings.setter(Builder::pipelineProvisioningRepository)).constructor(RepositoryBranch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineProvisioningRepository").build()}).build();
    private static final SdkField<String> PIPELINE_SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineServiceRoleArn").getter(AccountSettings.getter(AccountSettings::pipelineServiceRoleArn)).setter(AccountSettings.setter(Builder::pipelineServiceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineServiceRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_CODEBUILD_ROLE_ARN_FIELD, PIPELINE_PROVISIONING_REPOSITORY_FIELD, PIPELINE_SERVICE_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pipelineCodebuildRoleArn;
    private final RepositoryBranch pipelineProvisioningRepository;
    private final String pipelineServiceRoleArn;

    private AccountSettings(BuilderImpl builder) {
        this.pipelineCodebuildRoleArn = builder.pipelineCodebuildRoleArn;
        this.pipelineProvisioningRepository = builder.pipelineProvisioningRepository;
        this.pipelineServiceRoleArn = builder.pipelineServiceRoleArn;
    }

    public final String pipelineCodebuildRoleArn() {
        return this.pipelineCodebuildRoleArn;
    }

    public final RepositoryBranch pipelineProvisioningRepository() {
        return this.pipelineProvisioningRepository;
    }

    public final String pipelineServiceRoleArn() {
        return this.pipelineServiceRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineCodebuildRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineProvisioningRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineServiceRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings)obj;
        return Objects.equals(this.pipelineCodebuildRoleArn(), other.pipelineCodebuildRoleArn()) && Objects.equals(this.pipelineProvisioningRepository(), other.pipelineProvisioningRepository()) && Objects.equals(this.pipelineServiceRoleArn(), other.pipelineServiceRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"AccountSettings").add("PipelineCodebuildRoleArn", (Object)this.pipelineCodebuildRoleArn()).add("PipelineProvisioningRepository", (Object)this.pipelineProvisioningRepository()).add("PipelineServiceRoleArn", (Object)this.pipelineServiceRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineCodebuildRoleArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineCodebuildRoleArn()));
            }
            case "pipelineProvisioningRepository": {
                return Optional.ofNullable(clazz.cast(this.pipelineProvisioningRepository()));
            }
            case "pipelineServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineServiceRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pipelineCodebuildRoleArn", PIPELINE_CODEBUILD_ROLE_ARN_FIELD);
        map.put("pipelineProvisioningRepository", PIPELINE_PROVISIONING_REPOSITORY_FIELD);
        map.put("pipelineServiceRoleArn", PIPELINE_SERVICE_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountSettings, T> g) {
        return obj -> g.apply((AccountSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineCodebuildRoleArn;
        private RepositoryBranch pipelineProvisioningRepository;
        private String pipelineServiceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            this.pipelineCodebuildRoleArn(model.pipelineCodebuildRoleArn);
            this.pipelineProvisioningRepository(model.pipelineProvisioningRepository);
            this.pipelineServiceRoleArn(model.pipelineServiceRoleArn);
        }

        public final String getPipelineCodebuildRoleArn() {
            return this.pipelineCodebuildRoleArn;
        }

        public final void setPipelineCodebuildRoleArn(String pipelineCodebuildRoleArn) {
            this.pipelineCodebuildRoleArn = pipelineCodebuildRoleArn;
        }

        @Override
        public final Builder pipelineCodebuildRoleArn(String pipelineCodebuildRoleArn) {
            this.pipelineCodebuildRoleArn = pipelineCodebuildRoleArn;
            return this;
        }

        public final RepositoryBranch.Builder getPipelineProvisioningRepository() {
            return this.pipelineProvisioningRepository != null ? this.pipelineProvisioningRepository.toBuilder() : null;
        }

        public final void setPipelineProvisioningRepository(RepositoryBranch.BuilderImpl pipelineProvisioningRepository) {
            this.pipelineProvisioningRepository = pipelineProvisioningRepository != null ? pipelineProvisioningRepository.build() : null;
        }

        @Override
        public final Builder pipelineProvisioningRepository(RepositoryBranch pipelineProvisioningRepository) {
            this.pipelineProvisioningRepository = pipelineProvisioningRepository;
            return this;
        }

        public final String getPipelineServiceRoleArn() {
            return this.pipelineServiceRoleArn;
        }

        public final void setPipelineServiceRoleArn(String pipelineServiceRoleArn) {
            this.pipelineServiceRoleArn = pipelineServiceRoleArn;
        }

        @Override
        public final Builder pipelineServiceRoleArn(String pipelineServiceRoleArn) {
            this.pipelineServiceRoleArn = pipelineServiceRoleArn;
            return this;
        }

        public AccountSettings build() {
            return new AccountSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountSettings> {
        public Builder pipelineCodebuildRoleArn(String var1);

        public Builder pipelineProvisioningRepository(RepositoryBranch var1);

        default public Builder pipelineProvisioningRepository(Consumer<RepositoryBranch.Builder> pipelineProvisioningRepository) {
            return this.pipelineProvisioningRepository((RepositoryBranch)((RepositoryBranch.Builder)RepositoryBranch.builder().applyMutation(pipelineProvisioningRepository)).build());
        }

        public Builder pipelineServiceRoleArn(String var1);
    }
}

