/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentAccountConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentAccountConnection> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EnvironmentAccountConnection.getter(EnvironmentAccountConnection::arn)).setter(EnvironmentAccountConnection.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CODEBUILD_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codebuildRoleArn").getter(EnvironmentAccountConnection.getter(EnvironmentAccountConnection::codebuildRoleArn)).setter(EnvironmentAccountConnection.setter(Builder::codebuildRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codebuildRoleArn").build()}).build();
    private static final SdkField<String> COMPONENT_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentRoleArn").getter(EnvironmentAccountConnection.getter(EnvironmentAccountConnection::componentRoleArn)).setter(EnvironmentAccountConnection.setter(Builder::componentRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRoleArn").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentAccountId").getter(EnvironmentAccountConnection.getter(EnvironmentAccountConnection::environmentAccountId)).setter(EnvironmentAccountConnection.setter(Builder::environmentAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(EnvironmentAccountConnection.getter(EnvironmentAccountConnection::environmentName)).setter(EnvironmentAccountConnection.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(EnvironmentAccountConnection.getter(EnvironmentAccountConnection::id)).setter(EnvironmentAccountConnection.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(EnvironmentAccountConnection.getter(EnvironmentAccountConnection::lastModifiedAt)).setter(EnvironmentAccountConnection.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<String> MANAGEMENT_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managementAccountId").getter(EnvironmentAccountConnection.getter(EnvironmentAccountConnection::managementAccountId)).setter(EnvironmentAccountConnection.setter(Builder::managementAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementAccountId").build()}).build();
    private static final SdkField<Instant> REQUESTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("requestedAt").getter(EnvironmentAccountConnection.getter(EnvironmentAccountConnection::requestedAt)).setter(EnvironmentAccountConnection.setter(Builder::requestedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedAt").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(EnvironmentAccountConnection.getter(EnvironmentAccountConnection::roleArn)).setter(EnvironmentAccountConnection.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(EnvironmentAccountConnection.getter(EnvironmentAccountConnection::statusAsString)).setter(EnvironmentAccountConnection.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CODEBUILD_ROLE_ARN_FIELD, COMPONENT_ROLE_ARN_FIELD, ENVIRONMENT_ACCOUNT_ID_FIELD, ENVIRONMENT_NAME_FIELD, ID_FIELD, LAST_MODIFIED_AT_FIELD, MANAGEMENT_ACCOUNT_ID_FIELD, REQUESTED_AT_FIELD, ROLE_ARN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnvironmentAccountConnection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String codebuildRoleArn;
    private final String componentRoleArn;
    private final String environmentAccountId;
    private final String environmentName;
    private final String id;
    private final Instant lastModifiedAt;
    private final String managementAccountId;
    private final Instant requestedAt;
    private final String roleArn;
    private final String status;

    private EnvironmentAccountConnection(BuilderImpl builder) {
        this.arn = builder.arn;
        this.codebuildRoleArn = builder.codebuildRoleArn;
        this.componentRoleArn = builder.componentRoleArn;
        this.environmentAccountId = builder.environmentAccountId;
        this.environmentName = builder.environmentName;
        this.id = builder.id;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.managementAccountId = builder.managementAccountId;
        this.requestedAt = builder.requestedAt;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String codebuildRoleArn() {
        return this.codebuildRoleArn;
    }

    public final String componentRoleArn() {
        return this.componentRoleArn;
    }

    public final String environmentAccountId() {
        return this.environmentAccountId;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String managementAccountId() {
        return this.managementAccountId;
    }

    public final Instant requestedAt() {
        return this.requestedAt;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final EnvironmentAccountConnectionStatus status() {
        return EnvironmentAccountConnectionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.codebuildRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.managementAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentAccountConnection)) {
            return false;
        }
        EnvironmentAccountConnection other = (EnvironmentAccountConnection)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.codebuildRoleArn(), other.codebuildRoleArn()) && Objects.equals(this.componentRoleArn(), other.componentRoleArn()) && Objects.equals(this.environmentAccountId(), other.environmentAccountId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.managementAccountId(), other.managementAccountId()) && Objects.equals(this.requestedAt(), other.requestedAt()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentAccountConnection").add("Arn", (Object)this.arn()).add("CodebuildRoleArn", (Object)this.codebuildRoleArn()).add("ComponentRoleArn", (Object)this.componentRoleArn()).add("EnvironmentAccountId", (Object)this.environmentAccountId()).add("EnvironmentName", (Object)this.environmentName()).add("Id", (Object)this.id()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("ManagementAccountId", (Object)this.managementAccountId()).add("RequestedAt", (Object)this.requestedAt()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "codebuildRoleArn": {
                return Optional.ofNullable(clazz.cast(this.codebuildRoleArn()));
            }
            case "componentRoleArn": {
                return Optional.ofNullable(clazz.cast(this.componentRoleArn()));
            }
            case "environmentAccountId": {
                return Optional.ofNullable(clazz.cast(this.environmentAccountId()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "managementAccountId": {
                return Optional.ofNullable(clazz.cast(this.managementAccountId()));
            }
            case "requestedAt": {
                return Optional.ofNullable(clazz.cast(this.requestedAt()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("codebuildRoleArn", CODEBUILD_ROLE_ARN_FIELD);
        map.put("componentRoleArn", COMPONENT_ROLE_ARN_FIELD);
        map.put("environmentAccountId", ENVIRONMENT_ACCOUNT_ID_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("managementAccountId", MANAGEMENT_ACCOUNT_ID_FIELD);
        map.put("requestedAt", REQUESTED_AT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentAccountConnection, T> g) {
        return obj -> g.apply((EnvironmentAccountConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String codebuildRoleArn;
        private String componentRoleArn;
        private String environmentAccountId;
        private String environmentName;
        private String id;
        private Instant lastModifiedAt;
        private String managementAccountId;
        private Instant requestedAt;
        private String roleArn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentAccountConnection model) {
            this.arn(model.arn);
            this.codebuildRoleArn(model.codebuildRoleArn);
            this.componentRoleArn(model.componentRoleArn);
            this.environmentAccountId(model.environmentAccountId);
            this.environmentName(model.environmentName);
            this.id(model.id);
            this.lastModifiedAt(model.lastModifiedAt);
            this.managementAccountId(model.managementAccountId);
            this.requestedAt(model.requestedAt);
            this.roleArn(model.roleArn);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCodebuildRoleArn() {
            return this.codebuildRoleArn;
        }

        public final void setCodebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
        }

        @Override
        public final Builder codebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
            return this;
        }

        public final String getComponentRoleArn() {
            return this.componentRoleArn;
        }

        public final void setComponentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
        }

        @Override
        public final Builder componentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
            return this;
        }

        public final String getEnvironmentAccountId() {
            return this.environmentAccountId;
        }

        public final void setEnvironmentAccountId(String environmentAccountId) {
            this.environmentAccountId = environmentAccountId;
        }

        @Override
        public final Builder environmentAccountId(String environmentAccountId) {
            this.environmentAccountId = environmentAccountId;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getManagementAccountId() {
            return this.managementAccountId;
        }

        public final void setManagementAccountId(String managementAccountId) {
            this.managementAccountId = managementAccountId;
        }

        @Override
        public final Builder managementAccountId(String managementAccountId) {
            this.managementAccountId = managementAccountId;
            return this;
        }

        public final Instant getRequestedAt() {
            return this.requestedAt;
        }

        public final void setRequestedAt(Instant requestedAt) {
            this.requestedAt = requestedAt;
        }

        @Override
        public final Builder requestedAt(Instant requestedAt) {
            this.requestedAt = requestedAt;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentAccountConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public EnvironmentAccountConnection build() {
            return new EnvironmentAccountConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentAccountConnection> {
        public Builder arn(String var1);

        public Builder codebuildRoleArn(String var1);

        public Builder componentRoleArn(String var1);

        public Builder environmentAccountId(String var1);

        public Builder environmentName(String var1);

        public Builder id(String var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder managementAccountId(String var1);

        public Builder requestedAt(Instant var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(EnvironmentAccountConnectionStatus var1);
    }
}

