/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.Tag;
import software.amazon.awssdk.services.proton.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentAccountConnectionRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentAccountConnectionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateEnvironmentAccountConnectionRequest.getter(CreateEnvironmentAccountConnectionRequest::clientToken)).setter(CreateEnvironmentAccountConnectionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CODEBUILD_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codebuildRoleArn").getter(CreateEnvironmentAccountConnectionRequest.getter(CreateEnvironmentAccountConnectionRequest::codebuildRoleArn)).setter(CreateEnvironmentAccountConnectionRequest.setter(Builder::codebuildRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codebuildRoleArn").build()}).build();
    private static final SdkField<String> COMPONENT_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentRoleArn").getter(CreateEnvironmentAccountConnectionRequest.getter(CreateEnvironmentAccountConnectionRequest::componentRoleArn)).setter(CreateEnvironmentAccountConnectionRequest.setter(Builder::componentRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRoleArn").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(CreateEnvironmentAccountConnectionRequest.getter(CreateEnvironmentAccountConnectionRequest::environmentName)).setter(CreateEnvironmentAccountConnectionRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> MANAGEMENT_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managementAccountId").getter(CreateEnvironmentAccountConnectionRequest.getter(CreateEnvironmentAccountConnectionRequest::managementAccountId)).setter(CreateEnvironmentAccountConnectionRequest.setter(Builder::managementAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementAccountId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateEnvironmentAccountConnectionRequest.getter(CreateEnvironmentAccountConnectionRequest::roleArn)).setter(CreateEnvironmentAccountConnectionRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateEnvironmentAccountConnectionRequest.getter(CreateEnvironmentAccountConnectionRequest::tags)).setter(CreateEnvironmentAccountConnectionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CODEBUILD_ROLE_ARN_FIELD, COMPONENT_ROLE_ARN_FIELD, ENVIRONMENT_NAME_FIELD, MANAGEMENT_ACCOUNT_ID_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("codebuildRoleArn", CODEBUILD_ROLE_ARN_FIELD);
            this.put("componentRoleArn", COMPONENT_ROLE_ARN_FIELD);
            this.put("environmentName", ENVIRONMENT_NAME_FIELD);
            this.put("managementAccountId", MANAGEMENT_ACCOUNT_ID_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String clientToken;
    private final String codebuildRoleArn;
    private final String componentRoleArn;
    private final String environmentName;
    private final String managementAccountId;
    private final String roleArn;
    private final List<Tag> tags;

    private CreateEnvironmentAccountConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.codebuildRoleArn = builder.codebuildRoleArn;
        this.componentRoleArn = builder.componentRoleArn;
        this.environmentName = builder.environmentName;
        this.managementAccountId = builder.managementAccountId;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String codebuildRoleArn() {
        return this.codebuildRoleArn;
    }

    public final String componentRoleArn() {
        return this.componentRoleArn;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String managementAccountId() {
        return this.managementAccountId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.codebuildRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.managementAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentAccountConnectionRequest)) {
            return false;
        }
        CreateEnvironmentAccountConnectionRequest other = (CreateEnvironmentAccountConnectionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.codebuildRoleArn(), other.codebuildRoleArn()) && Objects.equals(this.componentRoleArn(), other.componentRoleArn()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.managementAccountId(), other.managementAccountId()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentAccountConnectionRequest").add("ClientToken", (Object)this.clientToken()).add("CodebuildRoleArn", (Object)this.codebuildRoleArn()).add("ComponentRoleArn", (Object)this.componentRoleArn()).add("EnvironmentName", (Object)this.environmentName()).add("ManagementAccountId", (Object)this.managementAccountId()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "codebuildRoleArn": {
                return Optional.ofNullable(clazz.cast(this.codebuildRoleArn()));
            }
            case "componentRoleArn": {
                return Optional.ofNullable(clazz.cast(this.componentRoleArn()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "managementAccountId": {
                return Optional.ofNullable(clazz.cast(this.managementAccountId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentAccountConnectionRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentAccountConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String codebuildRoleArn;
        private String componentRoleArn;
        private String environmentName;
        private String managementAccountId;
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentAccountConnectionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.codebuildRoleArn(model.codebuildRoleArn);
            this.componentRoleArn(model.componentRoleArn);
            this.environmentName(model.environmentName);
            this.managementAccountId(model.managementAccountId);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCodebuildRoleArn() {
            return this.codebuildRoleArn;
        }

        public final void setCodebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
        }

        @Override
        public final Builder codebuildRoleArn(String codebuildRoleArn) {
            this.codebuildRoleArn = codebuildRoleArn;
            return this;
        }

        public final String getComponentRoleArn() {
            return this.componentRoleArn;
        }

        public final void setComponentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
        }

        @Override
        public final Builder componentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getManagementAccountId() {
            return this.managementAccountId;
        }

        public final void setManagementAccountId(String managementAccountId) {
            this.managementAccountId = managementAccountId;
        }

        @Override
        public final Builder managementAccountId(String managementAccountId) {
            this.managementAccountId = managementAccountId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentAccountConnectionRequest build() {
            return new CreateEnvironmentAccountConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentAccountConnectionRequest> {
        public Builder clientToken(String var1);

        public Builder codebuildRoleArn(String var1);

        public Builder componentRoleArn(String var1);

        public Builder environmentName(String var1);

        public Builder managementAccountId(String var1);

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

