/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.RepositorySyncEvent;
import software.amazon.awssdk.services.proton.model.RepositorySyncEventsCopier;
import software.amazon.awssdk.services.proton.model.RepositorySyncStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositorySyncAttempt
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositorySyncAttempt> {
    private static final SdkField<List<RepositorySyncEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("events").getter(RepositorySyncAttempt.getter(RepositorySyncAttempt::events)).setter(RepositorySyncAttempt.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositorySyncEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(RepositorySyncAttempt.getter(RepositorySyncAttempt::startedAt)).setter(RepositorySyncAttempt.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RepositorySyncAttempt.getter(RepositorySyncAttempt::statusAsString)).setter(RepositorySyncAttempt.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD, STARTED_AT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("events", EVENTS_FIELD);
            this.put("startedAt", STARTED_AT_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<RepositorySyncEvent> events;
    private final Instant startedAt;
    private final String status;

    private RepositorySyncAttempt(BuilderImpl builder) {
        this.events = builder.events;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<RepositorySyncEvent> events() {
        return this.events;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final RepositorySyncStatus status() {
        return RepositorySyncStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositorySyncAttempt)) {
            return false;
        }
        RepositorySyncAttempt other = (RepositorySyncAttempt)obj;
        return this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RepositorySyncAttempt").add("Events", this.hasEvents() ? this.events() : null).add("StartedAt", (Object)this.startedAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RepositorySyncAttempt, T> g) {
        return obj -> g.apply((RepositorySyncAttempt)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RepositorySyncEvent> events = DefaultSdkAutoConstructList.getInstance();
        private Instant startedAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositorySyncAttempt model) {
            this.events(model.events);
            this.startedAt(model.startedAt);
            this.status(model.status);
        }

        public final List<RepositorySyncEvent.Builder> getEvents() {
            List<RepositorySyncEvent.Builder> result = RepositorySyncEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<RepositorySyncEvent.BuilderImpl> events) {
            this.events = RepositorySyncEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<RepositorySyncEvent> events) {
            this.events = RepositorySyncEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(RepositorySyncEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<RepositorySyncEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (RepositorySyncEvent)((RepositorySyncEvent.Builder)RepositorySyncEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RepositorySyncStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public RepositorySyncAttempt build() {
            return new RepositorySyncAttempt(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositorySyncAttempt> {
        public Builder events(Collection<RepositorySyncEvent> var1);

        public Builder events(RepositorySyncEvent ... var1);

        public Builder events(Consumer<RepositorySyncEvent.Builder> ... var1);

        public Builder startedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(RepositorySyncStatus var1);
    }
}

