/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.proton.DefaultProtonBaseClientBuilder;
import software.amazon.awssdk.services.proton.DefaultProtonClient;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.ProtonClientBuilder;
import software.amazon.awssdk.services.proton.ProtonServiceClientConfiguration;
import software.amazon.awssdk.services.proton.endpoints.ProtonEndpointProvider;

@SdkInternalApi
final class DefaultProtonClientBuilder
extends DefaultProtonBaseClientBuilder<ProtonClientBuilder, ProtonClient>
implements ProtonClientBuilder {
    DefaultProtonClientBuilder() {
    }

    @Override
    public DefaultProtonClientBuilder endpointProvider(ProtonEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ProtonClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultProtonClientBuilder.validateClientOptions(clientConfiguration);
        ProtonServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultProtonClient client = new DefaultProtonClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ProtonServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ProtonServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

