/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary data of a linked repository—a repository that has been registered with Proton.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositorySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositorySummary.Builder, RepositorySummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RepositorySummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionArn").getter(getter(RepositorySummary::connectionArn)).setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RepositorySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(RepositorySummary::providerAsString)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONNECTION_ARN_FIELD, NAME_FIELD, PROVIDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String connectionArn;

    private final String name;

    private final String provider;

    private RepositorySummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.connectionArn = builder.connectionArn;
        this.name = builder.name;
        this.provider = builder.provider;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the linked repository.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the linked repository.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the of your connection that connects Proton to your repository.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the of your connection that connects Proton to your repository.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The repository name.
     * </p>
     * 
     * @return The repository name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return The repository provider.
     * @see RepositoryProvider
     */
    public final RepositoryProvider provider() {
        return RepositoryProvider.fromValue(provider);
    }

    /**
     * <p>
     * The repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provider} will
     * return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerAsString}.
     * </p>
     * 
     * @return The repository provider.
     * @see RepositoryProvider
     */
    public final String providerAsString() {
        return provider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(providerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositorySummary)) {
            return false;
        }
        RepositorySummary other = (RepositorySummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(name(), other.name()) && Objects.equals(providerAsString(), other.providerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositorySummary").add("Arn", arn()).add("ConnectionArn", connectionArn()).add("Name", name())
                .add("Provider", providerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "connectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "provider":
            return Optional.ofNullable(clazz.cast(providerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositorySummary, T> g) {
        return obj -> g.apply((RepositorySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositorySummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the linked repository.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the linked repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the of your connection that connects Proton to your repository.
         * </p>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) of the of your connection that connects Proton to your repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The repository name.
         * </p>
         * 
         * @param name
         *        The repository name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The repository provider.
         * </p>
         * 
         * @param provider
         *        The repository provider.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder provider(String provider);

        /**
         * <p>
         * The repository provider.
         * </p>
         * 
         * @param provider
         *        The repository provider.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder provider(RepositoryProvider provider);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String connectionArn;

        private String name;

        private String provider;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositorySummary model) {
            arn(model.arn);
            connectionArn(model.connectionArn);
            name(model.name);
            provider(model.provider);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public final Builder provider(RepositoryProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        @Override
        public RepositorySummary build() {
            return new RepositorySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
