/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An infrastructure as code defined resource output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Output implements SdkPojo, Serializable, ToCopyableBuilder<Output.Builder, Output> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(Output::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> VALUE_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("valueString").getter(getter(Output::valueString)).setter(setter(Builder::valueString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String valueString;

    private Output(BuilderImpl builder) {
        this.key = builder.key;
        this.valueString = builder.valueString;
    }

    /**
     * <p>
     * The output key.
     * </p>
     * 
     * @return The output key.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The output value.
     * </p>
     * 
     * @return The output value.
     */
    public final String valueString() {
        return valueString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(valueString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(valueString(), other.valueString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Output").add("Key", key()).add("ValueString", valueString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "valueString":
            return Optional.ofNullable(clazz.cast(valueString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Output> {
        /**
         * <p>
         * The output key.
         * </p>
         * 
         * @param key
         *        The output key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The output value.
         * </p>
         * 
         * @param valueString
         *        The output value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueString(String valueString);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String valueString;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            key(model.key);
            valueString(model.valueString);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValueString() {
            return valueString;
        }

        public final void setValueString(String valueString) {
            this.valueString = valueString;
        }

        @Override
        public final Builder valueString(String valueString) {
            this.valueString = valueString;
            return this;
        }

        @Override
        public Output build() {
            return new Output(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
