/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceInstancesResponse extends ProtonResponse implements
        ToCopyableBuilder<ListServiceInstancesResponse.Builder, ListServiceInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServiceInstancesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ServiceInstanceSummary>> SERVICE_INSTANCES_FIELD = SdkField
            .<List<ServiceInstanceSummary>> builder(MarshallingType.LIST)
            .memberName("serviceInstances")
            .getter(getter(ListServiceInstancesResponse::serviceInstances))
            .setter(setter(Builder::serviceInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceInstanceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceInstanceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SERVICE_INSTANCES_FIELD));

    private final String nextToken;

    private final List<ServiceInstanceSummary> serviceInstances;

    private ListServiceInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serviceInstances = builder.serviceInstances;
    }

    /**
     * <p>
     * A token that indicates the location of the next service instance in the array of service instances, after the
     * current requested list of service instances.
     * </p>
     * 
     * @return A token that indicates the location of the next service instance in the array of service instances, after
     *         the current requested list of service instances.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceInstances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceInstances() {
        return serviceInstances != null && !(serviceInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of service instances with summary data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceInstances} method.
     * </p>
     * 
     * @return An array of service instances with summary data.
     */
    public final List<ServiceInstanceSummary> serviceInstances() {
        return serviceInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceInstances() ? serviceInstances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceInstancesResponse)) {
            return false;
        }
        ListServiceInstancesResponse other = (ListServiceInstancesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasServiceInstances() == other.hasServiceInstances()
                && Objects.equals(serviceInstances(), other.serviceInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceInstancesResponse").add("NextToken", nextToken())
                .add("ServiceInstances", hasServiceInstances() ? serviceInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "serviceInstances":
            return Optional.ofNullable(clazz.cast(serviceInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceInstancesResponse, T> g) {
        return obj -> g.apply((ListServiceInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListServiceInstancesResponse> {
        /**
         * <p>
         * A token that indicates the location of the next service instance in the array of service instances, after the
         * current requested list of service instances.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the location of the next service instance in the array of service instances,
         *        after the current requested list of service instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of service instances with summary data.
         * </p>
         * 
         * @param serviceInstances
         *        An array of service instances with summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstances(Collection<ServiceInstanceSummary> serviceInstances);

        /**
         * <p>
         * An array of service instances with summary data.
         * </p>
         * 
         * @param serviceInstances
         *        An array of service instances with summary data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstances(ServiceInstanceSummary... serviceInstances);

        /**
         * <p>
         * An array of service instances with summary data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.ServiceInstanceSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.proton.model.ServiceInstanceSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.proton.model.ServiceInstanceSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceInstances(List<ServiceInstanceSummary>)}.
         * 
         * @param serviceInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.proton.model.ServiceInstanceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceInstances(java.util.Collection<ServiceInstanceSummary>)
         */
        Builder serviceInstances(Consumer<ServiceInstanceSummary.Builder>... serviceInstances);
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ServiceInstanceSummary> serviceInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceInstancesResponse model) {
            super(model);
            nextToken(model.nextToken);
            serviceInstances(model.serviceInstances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceInstanceSummary.Builder> getServiceInstances() {
            List<ServiceInstanceSummary.Builder> result = ServiceInstanceSummaryListCopier.copyToBuilder(this.serviceInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceInstances(Collection<ServiceInstanceSummary.BuilderImpl> serviceInstances) {
            this.serviceInstances = ServiceInstanceSummaryListCopier.copyFromBuilder(serviceInstances);
        }

        @Override
        public final Builder serviceInstances(Collection<ServiceInstanceSummary> serviceInstances) {
            this.serviceInstances = ServiceInstanceSummaryListCopier.copy(serviceInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceInstances(ServiceInstanceSummary... serviceInstances) {
            serviceInstances(Arrays.asList(serviceInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceInstances(Consumer<ServiceInstanceSummary.Builder>... serviceInstances) {
            serviceInstances(Stream.of(serviceInstances).map(c -> ServiceInstanceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListServiceInstancesResponse build() {
            return new ListServiceInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
