/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRepositorySyncDefinitionsRequest extends ProtonRequest implements
        ToCopyableBuilder<ListRepositorySyncDefinitionsRequest.Builder, ListRepositorySyncDefinitionsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRepositorySyncDefinitionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(ListRepositorySyncDefinitionsRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> REPOSITORY_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryProvider").getter(getter(ListRepositorySyncDefinitionsRequest::repositoryProviderAsString))
            .setter(setter(Builder::repositoryProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryProvider").build())
            .build();

    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncType").getter(getter(ListRepositorySyncDefinitionsRequest::syncTypeAsString))
            .setter(setter(Builder::syncType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REPOSITORY_NAME_FIELD, REPOSITORY_PROVIDER_FIELD, SYNC_TYPE_FIELD));

    private final String nextToken;

    private final String repositoryName;

    private final String repositoryProvider;

    private final String syncType;

    private ListRepositorySyncDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.repositoryName = builder.repositoryName;
        this.repositoryProvider = builder.repositoryProvider;
        this.syncType = builder.syncType;
    }

    /**
     * <p>
     * A token that indicates the location of the next repository sync definition in the array of repository sync
     * definitions, after the list of repository sync definitions previously requested.
     * </p>
     * 
     * @return A token that indicates the location of the next repository sync definition in the array of repository
     *         sync definitions, after the list of repository sync definitions previously requested.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The repository name.
     * </p>
     * 
     * @return The repository name.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryProvider} will return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #repositoryProviderAsString}.
     * </p>
     * 
     * @return The repository provider.
     * @see RepositoryProvider
     */
    public final RepositoryProvider repositoryProvider() {
        return RepositoryProvider.fromValue(repositoryProvider);
    }

    /**
     * <p>
     * The repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #repositoryProvider} will return {@link RepositoryProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #repositoryProviderAsString}.
     * </p>
     * 
     * @return The repository provider.
     * @see RepositoryProvider
     */
    public final String repositoryProviderAsString() {
        return repositoryProvider;
    }

    /**
     * <p>
     * The sync type. The only supported value is <code>TEMPLATE_SYNC</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The sync type. The only supported value is <code>TEMPLATE_SYNC</code>.
     * @see SyncType
     */
    public final SyncType syncType() {
        return SyncType.fromValue(syncType);
    }

    /**
     * <p>
     * The sync type. The only supported value is <code>TEMPLATE_SYNC</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncType} will
     * return {@link SyncType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syncTypeAsString}.
     * </p>
     * 
     * @return The sync type. The only supported value is <code>TEMPLATE_SYNC</code>.
     * @see SyncType
     */
    public final String syncTypeAsString() {
        return syncType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(syncTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositorySyncDefinitionsRequest)) {
            return false;
        }
        ListRepositorySyncDefinitionsRequest other = (ListRepositorySyncDefinitionsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(repositoryProviderAsString(), other.repositoryProviderAsString())
                && Objects.equals(syncTypeAsString(), other.syncTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRepositorySyncDefinitionsRequest").add("NextToken", nextToken())
                .add("RepositoryName", repositoryName()).add("RepositoryProvider", repositoryProviderAsString())
                .add("SyncType", syncTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "repositoryProvider":
            return Optional.ofNullable(clazz.cast(repositoryProviderAsString()));
        case "syncType":
            return Optional.ofNullable(clazz.cast(syncTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositorySyncDefinitionsRequest, T> g) {
        return obj -> g.apply((ListRepositorySyncDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRepositorySyncDefinitionsRequest> {
        /**
         * <p>
         * A token that indicates the location of the next repository sync definition in the array of repository sync
         * definitions, after the list of repository sync definitions previously requested.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the location of the next repository sync definition in the array of repository
         *        sync definitions, after the list of repository sync definitions previously requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The repository name.
         * </p>
         * 
         * @param repositoryName
         *        The repository name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The repository provider.
         * </p>
         * 
         * @param repositoryProvider
         *        The repository provider.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder repositoryProvider(String repositoryProvider);

        /**
         * <p>
         * The repository provider.
         * </p>
         * 
         * @param repositoryProvider
         *        The repository provider.
         * @see RepositoryProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryProvider
         */
        Builder repositoryProvider(RepositoryProvider repositoryProvider);

        /**
         * <p>
         * The sync type. The only supported value is <code>TEMPLATE_SYNC</code>.
         * </p>
         * 
         * @param syncType
         *        The sync type. The only supported value is <code>TEMPLATE_SYNC</code>.
         * @see SyncType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncType
         */
        Builder syncType(String syncType);

        /**
         * <p>
         * The sync type. The only supported value is <code>TEMPLATE_SYNC</code>.
         * </p>
         * 
         * @param syncType
         *        The sync type. The only supported value is <code>TEMPLATE_SYNC</code>.
         * @see SyncType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SyncType
         */
        Builder syncType(SyncType syncType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String nextToken;

        private String repositoryName;

        private String repositoryProvider;

        private String syncType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositorySyncDefinitionsRequest model) {
            super(model);
            nextToken(model.nextToken);
            repositoryName(model.repositoryName);
            repositoryProvider(model.repositoryProvider);
            syncType(model.syncType);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryProvider() {
            return repositoryProvider;
        }

        public final void setRepositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
        }

        @Override
        public final Builder repositoryProvider(String repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
            return this;
        }

        @Override
        public final Builder repositoryProvider(RepositoryProvider repositoryProvider) {
            this.repositoryProvider(repositoryProvider == null ? null : repositoryProvider.toString());
            return this;
        }

        public final String getSyncType() {
            return syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        @Override
        public final Builder syncType(SyncType syncType) {
            this.syncType(syncType == null ? null : syncType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRepositorySyncDefinitionsRequest build() {
            return new ListRepositorySyncDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
