/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentAccountConnectionsResponse extends ProtonResponse implements
        ToCopyableBuilder<ListEnvironmentAccountConnectionsResponse.Builder, ListEnvironmentAccountConnectionsResponse> {
    private static final SdkField<List<EnvironmentAccountConnectionSummary>> ENVIRONMENT_ACCOUNT_CONNECTIONS_FIELD = SdkField
            .<List<EnvironmentAccountConnectionSummary>> builder(MarshallingType.LIST)
            .memberName("environmentAccountConnections")
            .getter(getter(ListEnvironmentAccountConnectionsResponse::environmentAccountConnections))
            .setter(setter(Builder::environmentAccountConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountConnections")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentAccountConnectionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentAccountConnectionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnvironmentAccountConnectionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENVIRONMENT_ACCOUNT_CONNECTIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<EnvironmentAccountConnectionSummary> environmentAccountConnections;

    private final String nextToken;

    private ListEnvironmentAccountConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.environmentAccountConnections = builder.environmentAccountConnections;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentAccountConnections property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnvironmentAccountConnections() {
        return environmentAccountConnections != null && !(environmentAccountConnections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of environment account connections with details that's returned by Proton.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentAccountConnections} method.
     * </p>
     * 
     * @return An array of environment account connections with details that's returned by Proton.
     */
    public final List<EnvironmentAccountConnectionSummary> environmentAccountConnections() {
        return environmentAccountConnections;
    }

    /**
     * <p>
     * A token that indicates the location of the next environment account connection in the array of environment
     * account connections, after the current requested list of environment account connections.
     * </p>
     * 
     * @return A token that indicates the location of the next environment account connection in the array of
     *         environment account connections, after the current requested list of environment account connections.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentAccountConnections() ? environmentAccountConnections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentAccountConnectionsResponse)) {
            return false;
        }
        ListEnvironmentAccountConnectionsResponse other = (ListEnvironmentAccountConnectionsResponse) obj;
        return hasEnvironmentAccountConnections() == other.hasEnvironmentAccountConnections()
                && Objects.equals(environmentAccountConnections(), other.environmentAccountConnections())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListEnvironmentAccountConnectionsResponse")
                .add("EnvironmentAccountConnections", hasEnvironmentAccountConnections() ? environmentAccountConnections() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentAccountConnections":
            return Optional.ofNullable(clazz.cast(environmentAccountConnections()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentAccountConnectionsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentAccountConnectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEnvironmentAccountConnectionsResponse> {
        /**
         * <p>
         * An array of environment account connections with details that's returned by Proton.
         * </p>
         * 
         * @param environmentAccountConnections
         *        An array of environment account connections with details that's returned by Proton.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentAccountConnections(Collection<EnvironmentAccountConnectionSummary> environmentAccountConnections);

        /**
         * <p>
         * An array of environment account connections with details that's returned by Proton.
         * </p>
         * 
         * @param environmentAccountConnections
         *        An array of environment account connections with details that's returned by Proton.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentAccountConnections(EnvironmentAccountConnectionSummary... environmentAccountConnections);

        /**
         * <p>
         * An array of environment account connections with details that's returned by Proton.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #environmentAccountConnections(List<EnvironmentAccountConnectionSummary>)}.
         * 
         * @param environmentAccountConnections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.proton.model.EnvironmentAccountConnectionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentAccountConnections(java.util.Collection<EnvironmentAccountConnectionSummary>)
         */
        Builder environmentAccountConnections(
                Consumer<EnvironmentAccountConnectionSummary.Builder>... environmentAccountConnections);

        /**
         * <p>
         * A token that indicates the location of the next environment account connection in the array of environment
         * account connections, after the current requested list of environment account connections.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the location of the next environment account connection in the array of
         *        environment account connections, after the current requested list of environment account connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private List<EnvironmentAccountConnectionSummary> environmentAccountConnections = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentAccountConnectionsResponse model) {
            super(model);
            environmentAccountConnections(model.environmentAccountConnections);
            nextToken(model.nextToken);
        }

        public final List<EnvironmentAccountConnectionSummary.Builder> getEnvironmentAccountConnections() {
            List<EnvironmentAccountConnectionSummary.Builder> result = EnvironmentAccountConnectionSummaryListCopier
                    .copyToBuilder(this.environmentAccountConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentAccountConnections(
                Collection<EnvironmentAccountConnectionSummary.BuilderImpl> environmentAccountConnections) {
            this.environmentAccountConnections = EnvironmentAccountConnectionSummaryListCopier
                    .copyFromBuilder(environmentAccountConnections);
        }

        @Override
        public final Builder environmentAccountConnections(
                Collection<EnvironmentAccountConnectionSummary> environmentAccountConnections) {
            this.environmentAccountConnections = EnvironmentAccountConnectionSummaryListCopier
                    .copy(environmentAccountConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentAccountConnections(EnvironmentAccountConnectionSummary... environmentAccountConnections) {
            environmentAccountConnections(Arrays.asList(environmentAccountConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentAccountConnections(
                Consumer<EnvironmentAccountConnectionSummary.Builder>... environmentAccountConnections) {
            environmentAccountConnections(Stream.of(environmentAccountConnections)
                    .map(c -> EnvironmentAccountConnectionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnvironmentAccountConnectionsResponse build() {
            return new ListEnvironmentAccountConnectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
